library ana;

uses
  SysUtils,
  windows,
  Classes;

const
// Kik selles moodulis kasutatud failinimed:
// vt ka ana_fail_dir muutujat
  yksik_fail = 'form.exc';
  yksik2_fail = 'form2.exc';
  yksik_max = 3000;
  derer_fail = 'der.exc';
  derer_max = 1000;
// ei pea olema
  indekl_fail = 'indekl.dic';
  indekl_max = 35;
// oli: indekl_max = 3500;

  ls_vxiketxhed = ['a'..'z',''..''];
  ls_suurtxhed = ['A'..'Z',''..''];
  lsosised_fail = 'osised.ls';
  ls_maxline = 10000;
  lsfonoer_fail = 'fonoer.ls';
  ls_maxfonoer = 100;
  lserandid_fail = 'erandid.ls';
  lsreeglid_fail = 'reeglid.ls';
  lskompo_fail = 'kompo.ls';
  ls_maxreegel = 500;

  charsini_fail = 'chars.ini';
  fcodesini_fail = 'fcodes.ini';

  ylatab_fail = 'yla-tab.';
  yk_maxline = 200;
  dertab_fail = 'der-tab.';
  formtab_fail = 'form-tab.';
  form_maxline = 200;
  lemmad_fail = 'lemma.dic';
  kasutaja_lemmad_fail = 'kasutaja.dic';

// 1 - sisekuju
// 2 - vorminimi
// 3 - klaarkood
// 4 - Filosoft
  maxvormiliik = 4;
  maxvormikood = 99;
var
  vormikoodid : array [1..maxvormikood,1..maxvormiliik] of string;
  ana_vorm_loetud : boolean;

const
  frq_max = 1000;
  tervikliitsqna_fail = 'tervik.ls';
  liitmxxrsqna_fail = 'indekl.ls';
  yhendverbid_fail = 'yh_verb.ls';
  lppiirangud_fail = 'osad.ls';
var
  tervikliitsqnad : Tstringlist;
  liitmxxrsqnad : Tstringlist;
  liitsqnad1p : Tstringlist;
  liitsqnad2p : Tstringlist;
  esikomponendiandmed : Tstringlist;
  yhendverbiandmed : Tstringlist;
type
  ls_reeglityyp =
  record
    r1, r2 : string;
    algus, lqpp : boolean;
  end;
  ls_reeglimassiiv = array [1..ls_maxreegel] of ls_reeglityyp;

type
  charset = set of char;
var
  ls_klassid : array ['A'..''] of charset;
  ls_kxsud, ls_keelud, ls_rgload, ls_poolkxsud, ls_erandid : ls_reeglimassiiv;
  ls_fonoer : array [1..ls_maxfonoer] of string;
  ls_kxske, ls_keelde, ls_rglube, ls_poolkxske, ls_erandeid : word;
  ls_sygavus : word;

const
  symb1 : charset = [' ', '''', '', '`', '.', ',', '+', '@'];
  symb2 : charset = ['''', '', '`', '.', ',', '+', '@'];
  GI = ['a','e','i','j','l','m','n','o','r','u','v','','','','','y'];

type
  anablokk =
  record
    sqna : string;              // sisendsna ilma lihtsustusteta
    tyvi : string;              (* analyysitava sqna tyvi *)
    lqpp : string;              (* analyysitava sqna lqpp *)

// formatiivid:

    tyvekood : string;          (* = failinimi, 02BT etc *)
    lemma : string;             (* lemmasqnastikust *)

// vxljundisse
    x_vormityvi : string;       // form-tab'i liigenduse esimene ots
    x_vormikood : string;       // form-tab'is formatiivi jrel
    x_giki : boolean;           //
    x_vormilemma : string;      // createlemmast
    x_tyypliik : string;        // findtypes vljundist
    x_dertyvi : string;         // der-tabi'i liigenduse esimene ots
    x_derkood : string;         // der-tab'is der-sufiksi jrel
    x_derlemma : string;        // createlemmast
  end;

const
  pseudotyype = 2;
type
  pseudotyybityyp = array [1..2*pseudotyype] of string;
const
  pseudotyybid : pseudotyybityyp = (
  '11_S~09_S', '80_S',
  '99_X', '99_X');

type
  kribud = array [1..6] of byte;

  lemmakirje =
  record
    lemma : string[14];
    kribu : kribud;
    sl1, sl2 : char;
    tyybinr : byte;
    paral : array [1..3] of char;
    viit : longint;
  end;
  lemmafail = file of lemmakirje;

  tyvekirje =
  record
    sona : string[25];
    lemm1 : string[5];
    lemm2 : string[5];
    viit : longint;
  end;
  tyvefail = file of tyvekirje;

  dattype = string[60];
  datfile = file of dattype;

  mrftyvekirje =
  record
    sona : string[17];
    kribu : kribud;
    lemm1, lemm2 : word;
    viit : longint;
  end;
  mrftyvefail = file of mrftyvekirje;

type
  Tyllesodi = class (Tobject)
    puhastamata : string;
    tyypliik : string;
    jxtka : boolean;
  end;
  Tesikomponent = class (Tobject)
    a : anablokk;
  end;
  Tliitsqnapoolepiirang = class (Tobject)
    tyypliik : string;
    sliik : string;
    vormikood : string;
  end;

const
   konsonandid : set of char =
   ['b','c','d','f','g','h','j','k','l','m','n','p',
    'q','r','s','','z','','t','v','w','x','y'];
   vokaalid : set of char =
   ['a','e','i','o','u','','','',''];

var
  ana_vorm : word;
  ana_fail_dir : string;
  ana_sqnastikuga, ana_tuletusega, ana_liitsqna : boolean;
// vilosohvti vljund, htlasi kolm eelmist true)
  ana_fsmode : boolean;
  ana_hqivatud : boolean;
  ana_formatiiv_vxljastati : boolean;
  ana_a_enne_tuletust : anablokk;
  ana_sisendsqna, ana_algusots : string;
  ana_ykskqikmis : boolean;
  ana_liitsqnaanalyys : boolean;
  ana_esikomponendianalyys : boolean;

// initsialiseerimisjupid kasutavad kordamda seda
  f : text;
  tulemus : string;
  leitud : boolean;
//  form_lipik : word;

function FindTypes (
  inputString  : PChar;
  outputString : PChar;
  outputLength : integer;
  durationmark : integer) : integer;
  stdcall; external 'typedet.dll';

procedure CreateLemma
  (InputString : PChar; StemNr : integer; StemCode : PChar;
   Lemma : PChar; LemmaLength : integer; History : PChar;
   HistLength : integer; withApp : integer); far stdcall external 'Stems.dll';

var
  SaveExit: Pointer;


//
// ==========================================================
// ==========================================================
//


// --------------------

const
  crnl = chr($0d) + chr($0a);
  vormikoodieraldaja = '  (';

function asenduskood (var sisekood : string; vorm : integer) : string;
var
  gilqpp : string;
  i : integer;
begin
  result := sisekood;
  i := length (sisekood);
  if (i > 0) and (sisekood[i] = '^') then
  begin
    delete (sisekood, i, 1);
// filosofti vljundis gi/ki lqpp ei kajastu
    if vorm <> 4 then gilqpp := '^';
  end else gilqpp := '';
  for i := 1 to maxvormikood do if (vormikoodid[i][1] = sisekood) then
  begin
    result := vormikoodid[i][vorm] + gilqpp;
    break;
  end;
end;

procedure vormikoodiasendus (var s : string);
// ana_vorm: 1 sisekood, 2 vorminimi, 3 klaarkood, 4 FS
var
  i : integer;
  uuss, vk : string;
begin
  if (ana_vorm = 1) then exit;
  if (ana_vorm = 4) then exit;
  uuss := '';
  repeat
    i := pos (vormikoodieraldaja, s);
    if i > 0 then
    begin
      i := i+length(vormikoodieraldaja)-1;
      uuss := uuss + copy (s, 1, i);
      delete (s, 1, i);
      i := pos (' ', s);
      if i = 0 then i := length(s) + 1;
      if (s <> '') and (i > 1) and (s[i-1] = '^') then dec (i);
      vk := copy (s, 1, i-1);
      delete (s, 1, i-1);
      uuss := uuss + asenduskood (vk, ana_vorm);
    end;
  until i = 0;
  s := uuss + s;
end;

procedure vxljasta_string (s : string);
begin
  vormikoodiasendus (s);
  tulemus := tulemus + s + crnl;
end;

function tyypliik_lahku (s : string) : string;
var
  i : integer;
begin
  i := 1;
  result := s;
  while i < 2*pseudotyype do
  begin
    result := stringreplace (result, pseudotyybid[i+1], pseudotyybid[i], []);
    i := i+2;
  end;
end;

function tyypliik_lahku_esimeseks (s : string) : string;
var
  i : integer;
begin
  i := 1;
  result := s;
  while i < 2*pseudotyype do
  begin
    result := stringreplace (result, pseudotyybid[i+1], pseudotyybid[i], []);
    i := i+2;
  end;
  i := 1;
  repeat inc (i) until (i > length(result)) or (result[i] in ['~', '?']);
  result := copy (result, 1, i-1);
end;

function tyypliik_kokku (s : string) : string;
var
  i : integer;
begin
  i := 1;
  result := s;
  while i < 2*pseudotyype do
  begin
    result := stringreplace (result, pseudotyybid[i], pseudotyybid[i+1], []);
    i := i+2;
  end;
end;

// ------------------------------------------------
function uusliitsqna (var a : anablokk; var vv : string) : boolean;
var
  i, j : integer;
  ea : anablokk;
  lpp : Tliitsqnapoolepiirang;
begin
  vv := '';

  {  1  }
  i := tervikliitsqnad.indexof (ana_algusots + a.x_vormilemma);
  if (i >= 0) then
  begin
    a.x_tyypliik := tyllesodi(tervikliitsqnad.objects[i]).tyypliik;
    result := true;
    exit;
  end;

  {  2  }
  for i := 0 to esikomponendiandmed.count-1 do
  begin
    ea := Tesikomponent(esikomponendiandmed.objects[i]).a;
    j := liitsqnad1p.indexof (ea.sqna);
    if j >= 0 then
    begin
      while (j >= 0) do
      begin
        lpp := Tliitsqnapoolepiirang(liitsqnad1p.objects[j]);
        if pos (lpp.sliik, a.x_tyypliik) > 0 then
        begin
//          vxljasta_string ('R-2');
          result := true; exit;
        end;
        inc (j);
        if (j >= liitsqnad1p.count) or (liitsqnad1p[j] <> ea.sqna)
        then j := -1;
      end;
      result := false; exit;
    end;
  end;

  {  3  }
  j := liitsqnad2p.indexof (a.x_vormilemma);
  if (j >= 0) then
  begin
    while (j >= 0) do
    begin
      lpp := Tliitsqnapoolepiirang(liitsqnad2p.objects[j]);
      if lpp.tyypliik = a.x_tyypliik then
      for i := 0 to esikomponendiandmed.count-1 do
      begin
        ea := Tesikomponent(esikomponendiandmed.objects[i]).a;
        if (pos (lpp.sliik, ea.x_tyypliik) > 0) and
           (lpp.vormikood = ea.x_vormikood) then
        begin
          result := true; exit;
        end;
      end;

      inc (j);
      if (j >= liitsqnad2p.count) or
         (liitsqnad2p[j] <> a.x_vormilemma)
      then j := -1;
    end;
    result := false; exit;
  end;

  case a.x_tyypliik[4] of
    {  4  }
    'S','A' : if (copy (a.x_tyypliik, 1, 2) <> '41') then
    begin
      result := true; exit;
    end;
    {  5  }
    'J','K','N','P' :
    begin
      result := false; exit;
    end;
    {  6  }
    'V' :
    begin
//      vxljasta_string ('R-6:' + ana_algusots + a.x_derlemma);
//      vxljasta_string ('R-6:' + ana_algusots + a.x_vormilemma);
      if a.x_derlemma <> ''
        then i := yhendverbiandmed.indexof (ana_algusots + a.x_derlemma)
        else i := yhendverbiandmed.indexof (ana_algusots + a.x_vormilemma);
      if i < 0 then
        i := yhendverbiandmed.indexof (ana_algusots);
      if i >= 0 then
      begin
// selliseid saab kokku kirjutada kui vorm on partitsiip vi mata
        if (a.x_vormikood <> '') and
           ((a.x_vormikood[1] = '4') or (a.x_vormikood = '30-----A'))
        then
        begin
          vv := '_'; result := true; exit;
        end;
      end;
    end;
  else end;
  result := false;
end;

var
  oli_frm : boolean;

procedure vxlja_frm (var a : anablokk);
var
  fs, xx, s : string;
  verbivahe : string;
  ek : Tesikomponent;
  i : integer;
begin
//  a.x_vormikood = '------1-' then exit;
//  if ana_algusots <> '' then s := '+' else s := '';
  if ana_esikomponendianalyys then
  begin
    ek := Tesikomponent.create;
    ek.a := a;
    esikomponendiandmed.addobject ('', ek);
    exit;
  end;
  if ana_liitsqnaanalyys and not uusliitsqna (a, verbivahe) then exit;

  if ana_ykskqikmis then s := '?' else s := '';

  s := s + ana_sisendsqna;
  s := s + ' =' + a.x_vormityvi;
  s := s + vormikoodieraldaja + a.x_vormikood;
  if a.x_giki then s := s + '^';
  s := s + '  >' + ana_algusots + verbivahe + a.x_vormilemma;
  s := s + ' !' + tyypliik_lahku (a.x_tyypliik);

  if (ana_fsmode) then
  begin
    fs := '    ';
    xx := ana_algusots + verbivahe;
    fs := fs + xx;
    xx := a.x_vormilemma;
    if (a.x_tyypliik[4] = 'V') and (copy(xx, length(xx)-1, 2) = 'ma')
      then delete (xx, length(xx)-1, 2);
    fs := fs + xx;
    for i := 1 to length (fs) do if fs[i] = '+' then fs[i] := '_';
    fs := stringreplace (fs, '__', '_', [rfreplaceall]);
    i := length (a.x_vormityvi);
    if copy (ana_sisendsqna, 1, i) = a.x_vormityvi
      then xx := copy (ana_sisendsqna, i+1, 100)
      else xx := a.lqpp;
    if xx = '' then xx := '0';
    fs := fs + '+' + xx + ' //_' + a.x_tyypliik[4] + '_';
    xx := asenduskood (a.x_vormikood, 4);
    if xx <> '' then xx := ' ' + xx + ',';
    fs := fs + xx + ' //  ';
    if length (a.x_tyypliik) > 4 then
    begin
      vxljasta_string (fs + s);
      i := pos ('//_', fs);
      fs[i+3] := a.x_tyypliik[5];
    end;
    s := fs + s;
  end;
  vxljasta_string (s);
  oli_frm := true;
end;

procedure vxlja_der (var a : anablokk);
var
  fs, xx, s : string;
  verbivahe : string;
  ek : tesikomponent;
  i, j : integer;
begin
//  if a.x_vormikood = '------1-' then exit;
  if ana_esikomponendianalyys then
  begin
    ek := Tesikomponent.create;
    ek.a := a;
    esikomponendiandmed.addobject ('', ek);
    exit;
  end;
  if ana_liitsqnaanalyys and not uusliitsqna (a, verbivahe) then exit;

  if ana_ykskqikmis then s := '?"' else s := '"';

  s := s + ana_algusots + a.x_vormilemma;
  s := s + ' %' + a.x_dertyvi;
  s := s + '  )' + a.x_derkood;
  if a.x_giki then s := s + '^';
  s := s + '  <' + ana_algusots + verbivahe + a.x_derlemma;
  s := s + ' ;' + tyypliik_lahku (a.x_tyypliik);

// "reegli+phine %phi  )NE_aA  <reegli+phi ;24_S

  if ana_fsmode then
  begin
    if oli_frm then
    begin
      fs := '    ' + ana_algusots + verbivahe;
      xx := a.x_vormilemma;
      if (a.x_tyypliik[4] = 'V') and (copy(xx, length(xx)-1, 2) = 'ma')
      then delete (xx, length(xx)-1, 2);

      j := length (a.x_dertyvi);
      if j <> 0 then
        for i := length(xx) - j downto 1 do
          if copy (xx, i, j) = a.x_dertyvi then
          begin
            insert ('=', xx, i+j);
            break;
          end;
      fs := fs + xx;
      for i := 1 to length (fs) do if fs[i] = '+' then fs[i] := '_';
      fs := stringreplace (fs, '__', '_', [rfreplaceall]);

      i := pos ('=', fs);
      j := length (tulemus);
      if i*j > 0 then
      begin
        repeat dec (j) until (j = 0) or (copy (tulemus, j, 2) = crnl);
        repeat dec (j) until (j = 0) or (copy (tulemus, j, 2) = crnl);
        if j > 0 then inc (j);
        insert ('=', tulemus, j+i);
      end;
    end;
  end
  else vxljasta_string (s);
  oli_frm := false;
end;

procedure lisarida (s : string);
begin
  tulemus := tulemus + s + crnl;
end;

function otsi_faili (nimi : string) : string;
begin
  result := ana_fail_dir + nimi;
  if fileexists (result) then
  begin
    lisarida ('Avan: ' + result);
    exit;
  end;
  result := nimi;
  if fileexists (result) then
  begin
    lisarida ('Avan jooksvast kataloogist: ' + result);
    exit;
  end;
  lisarida ('Ei leia faili ' + nimi);
  result := '';
end;

//
// ==========================================================
// ==========================================================
//


(* Liitsnakomponentide loend *)
var
  ls_arr : array [1..ls_maxline] of string;

// ------------------------------------------------------------------

procedure loe_lskomp;
var
  s : string;
  p : integer;
begin
  for p := 1 to ls_maxline do ls_arr[p] := '';
  s := otsi_faili (lsosised_fail);
  if s = '' then exit;
  assign (f, s); reset (f);
  p := 1;
  while not eof (f) do
  begin
    readln (f, s);
    if (pos(',',s) > 0) then delete (s, pos(',',s), 10);
    if (s <> '') and not (s[1] in ['#', ';']) and (p <= ls_maxline) then
    begin
      ls_arr[p] := trim(s);
      inc (p);
    end;
  end;
  close (f);
  lisarida ('... max '+inttostr(ls_maxline)+', kasutatud '+inttostr(p-1));
end;

function on_lskomp (var s : string) : boolean;
var
  min, mid, max : integer;
begin
  min := 0;
  max := ls_maxline;
  while (max > 1) and (ls_arr[max] = '') do dec (max);
  while (max-min) > 1 do
  begin
    mid := (min + max) div 2;
    if ls_arr[mid] < s then min := mid else max := mid;
  end;
  result := ls_arr[max] = s;
end;

procedure loe_tervikliitsqna;
var
  s, puhass : string;
  tagakomp : boolean;
  i, j : integer;
  y : Tyllesodi;
  lpp, lpp1 : Tliitsqnapoolepiirang;
begin
  tervikliitsqnad := Tstringlist.create;
  tervikliitsqnad.sorted := true;

  s := otsi_faili (tervikliitsqna_fail);
  if s <> '' then
  begin
    assign (f, s); reset (f);
    while not eof (f) do
    begin
      readln (f, s);
      s := trim (s);
      if (s <> '') and not (s[1] in ['#', ';']) then
      begin
        y := tyllesodi.create;
        puhass := copy (s, 1, pos(' ',s)-1);
        y.puhastamata := puhass;
        delete (s, 1, pos(' ',s));
        y.tyypliik := s;
        for i := length(puhass) downto 1 do
          if puhass[i] in [''''] then delete (puhass, i, 1);
        tervikliitsqnad.addobject (puhass, y);
      end;
    end;
    close (f);
  end;

  liitmxxrsqnad := tstringlist.create;
  liitmxxrsqnad.sorted := true;

  s := otsi_faili (liitmxxrsqna_fail);
  if s <> '' then
  begin
    assign (f, s); reset (f);
    while not eof (f) do
    begin
      readln (f, s);
      s := trim (s);
      if (s <> '') and not (s[1] in ['#', ';']) then
      begin
        for i := length(s) downto 1 do
          if s[i] = '''' then delete (s, i, 1);
        y := tyllesodi.create;
        i := pos (' ', s);
        puhass := copy (s, 1, i-1);
        delete (s, 1, i);
        y.puhastamata := puhass;
        for i := length(puhass) downto 1 do
          if puhass[i] in ['+'] then delete (puhass, i, 1);
        if pos (' >', s) > 0 then
        begin
          y.jxtka := true;
          s := copy (s, 1, pos(' ',s)-1);
        end;
        y.tyypliik := s;
        liitmxxrsqnad.addobject (puhass, y);
      end;
    end;
    close (f);
  end;

  esikomponendiandmed := tstringlist.create;
  liitsqnad1p := tstringlist.create;
  liitsqnad1p.sorted := true;
  liitsqnad1p.duplicates := dupAccept;
  liitsqnad2p := tstringlist.create;
//  liitsqnad2p.sorted := true;
  liitsqnad2p.duplicates := dupAccept;

  s := otsi_faili (lppiirangud_fail);
  if s <> '' then
  begin
    assign (f, s); reset (f);
    while not eof (f) do
    begin
      readln (f, s);
      s := trim (s);
      if (s <> '') and not (s[1] in ['#', ';']) then
      begin
        tagakomp := (s[1] = '+');
        for i := length(s) downto 1 do
          if s[i] in ['''', '+', '/'] then delete (s, i, 1);
        lpp := Tliitsqnapoolepiirang.create;
        s := s + ' ';
        i := pos (' ',s);
        puhass := copy (s, 1, i-1);
        delete (s, 1, i);
        if tagakomp then
        begin
          i := pos (' ',s);
          lpp.tyypliik := copy (s, 1, i-1);
          delete (s, 1, i);
        end;
        i := pos (' ',s);
        lpp.sliik := copy (s, 1, i-1);
        delete (s, 1, i);
        if tagakomp then
        begin
          i := pos (' ',s);
          lpp.vormikood := copy (s, 1, i-1);
          delete (s, 1, i);
        end;

        if tagakomp then
          liitsqnad2p.addobject (puhass, lpp)
        else
        begin
          while pos (',', lpp.sliik) > 0 do
          begin
            lpp1 := Tliitsqnapoolepiirang.create;
            lpp1.sliik := lpp.sliik;
            j := pos (',', lpp.sliik);
            lpp1.sliik := copy (lpp.sliik, 1, j-1);
            delete (lpp.sliik, 1, j);
            liitsqnad1p.addobject (puhass, lpp1);
          end;
          liitsqnad1p.addobject (puhass, lpp);
        end;
      end;
    end;
    close (f);
  end;

  i := 0;
  while i < liitsqnad2p.count do
  begin
    lpp := Tliitsqnapoolepiirang(liitsqnad2p.objects[i]);
    while pos (',', lpp.sliik) > 0 do
    begin
      lpp1 := Tliitsqnapoolepiirang.create;
      lpp1.tyypliik := lpp.tyypliik;
      lpp1.sliik := lpp.sliik;
      lpp1.vormikood := lpp.vormikood;
      j := pos (',', lpp.sliik);
      lpp.sliik := copy (lpp.sliik, 1, j-1);
      delete (lpp1.sliik, 1, j);
      liitsqnad2p.addobject (liitsqnad2p[i], lpp1);
    end;
    inc (i);
  end;
  i := 0;
  while i < liitsqnad2p.count do
  begin
    lpp := Tliitsqnapoolepiirang(liitsqnad2p.objects[i]);
    while pos (',', lpp.vormikood) > 0 do
    begin
      lpp1 := Tliitsqnapoolepiirang.create;
      lpp1.tyypliik := lpp.tyypliik;
      lpp1.sliik := lpp.sliik;
      lpp1.vormikood := lpp.vormikood;
      j := pos (',', lpp.vormikood);
      lpp.vormikood := copy (lpp.vormikood, 1, j-1);
      delete (lpp1.vormikood, 1, j);
      liitsqnad2p.addobject (liitsqnad2p[i], lpp1);
    end;
    inc (i);
  end;
  liitsqnad2p.sort;
  liitsqnad2p.sorted := true;

  lisarida ('...esikomponente tuli ' + inttostr(liitsqnad1p.count));
{
for i := 0 to liitsqnad1p.count-1 do
begin
  lpp := Tliitsqnapoolepiirang(liitsqnad1p.objects[i]);
  lisarida (liitsqnad1p[i]+'  '+lpp.tyypliik+':'+lpp.sliik+':'+lpp.vormikood);
end;
}
  lisarida ('...tagakomponente tuli ' + inttostr(liitsqnad2p.count));
{
for i := 0 to liitsqnad2p.count-1 do
begin
  lpp := Tliitsqnapoolepiirang(liitsqnad2p.objects[i]);
  lisarida (liitsqnad2p[i]+'  '+lpp.tyypliik+':'+lpp.sliik+':'+lpp.vormikood);
end;
}

  yhendverbiandmed := tstringlist.create;
  yhendverbiandmed.sorted := true;
  s := otsi_faili (yhendverbid_fail);
  if s <> '' then
  begin
    assign (f, s); reset (f);
    while not eof (f) do
    begin
      readln (f, s);
      s := trim (s);
      for i := length(s) downto 1 do if s[i] = '_' then s[i] := '+';
      if (s <> '') and not (s[1] in ['#', ';']) then
        yhendverbiandmed.add (s);
    end;
    close (f);
  end;
end;


//
// ==========================================================
// ==========================================================
//

(* Lemmade loend *)
type
  lemptrtype = ^lemrectype;
  lemrectype =
  record
    lemma, tyypliik : string;
    vasak, parem : lemptrtype;
  end;
var
  lp, ltmp, lembase : lemptrtype;

procedure killlptr (l : lemptrtype);
begin
  if l^.vasak <> nil then killlptr (l^.vasak);
  if l^.parem <> nil then killlptr (l^.parem);
  dispose (l);
end;

procedure lem_exit;
begin
  if lembase <> nil then killlptr (lembase);
  lembase := nil;
end;

procedure kustuta_lemma (s, tl : string);
begin
  if lembase = nil then exit;
  ltmp := lembase;
  repeat
// kustutamine
    if (ltmp^.lemma = s) and (ltmp^.tyypliik = tl) then ltmp^.tyypliik := 'xxx';
// lase natsa edasi ka siis kui leidsid, vib olla mitu tkki
    if (s <= ltmp^.lemma) and (ltmp^.vasak <> nil) then ltmp := ltmp^.vasak
    else
    if (s > ltmp^.lemma) and (ltmp^.parem <> nil) then ltmp := ltmp^.parem
    else
    exit;
  until false;
end;

procedure lisa_lemma (var s : string);
var
  i : integer;
begin
  if (s = '') or (s[1] in ['#', ';']) then exit;
  i := pos (' ', s);
  if s[1] = '-' then
  begin
    kustuta_lemma (copy (s, 2, i-2), copy (s, i+1, 10));
    exit;
  end;

  new (lp);
  lp^.lemma := copy (s, 1, i-1);
  lp^.tyypliik := copy (s, i+1, 10);
  lp^.vasak := nil;
  lp^.parem := nil;
// if lembase = nil then lisarida ('- uus lembase');

  if lembase = nil then lembase := lp
  else
  begin
    ltmp := lembase;
    repeat
      if (lp^.lemma <= ltmp^.lemma) then
      begin
// sss := sss + '0';
        if (ltmp^.vasak <> nil) then ltmp := ltmp^.vasak else
        begin
          ltmp^.vasak := lp;
// lisarida ('- ' + sss);
          exit;
        end;
      end
      else
      begin
// sss := sss + '1';
        if (ltmp.parem <> nil) then ltmp := ltmp.parem else
        begin
          ltmp^.parem := lp;
// lisarida ('- ' + sss);
          exit;
        end;
      end;
    until false;
  end;
end;

procedure loe_lemmad;
var
  s, eels : string;
  fbuf : array [1..4096] of char;
  c : char;
begin
  if lembase <> nil then lem_exit;
  s := otsi_faili (lemmad_fail);
  if s = '' then exit;
  assignfile (f, s);
  system.settextbuf (f, fbuf);
  reset (f);

  lisarida ('... pakin lahti ja ehitan puu');
  s := '';
  while not eof (f) do
  begin
    read (f, c);
    if c < ' ' then
    begin
      s := s + copy (eels, length(eels)+1-ord(c), ord(c));
      lisa_lemma (s);
      eels := s;
      s := '';
    end else s := s + c;
  end;
  closefile (f);

  s := otsi_faili (kasutaja_lemmad_fail);
  if s = '' then exit;
  assignfile (f, s); reset (f);
  while not eof (f) do
  begin
    readln (f, s);
    s := trim (s);
    lisa_lemma (s);
  end;
  closefile (f);
end;

function on_lemma (var s, tl : string) : boolean;
begin
  if lembase = nil then
  begin
    result := false; exit;
  end;

  ltmp := lembase;
  repeat
    if (ltmp^.lemma = s) and (ltmp^.tyypliik = tl) then
    begin
      result := true; exit;
    end;

    if (s <= ltmp^.lemma) and (ltmp^.vasak <> nil) then ltmp := ltmp^.vasak
    else
    if (s > ltmp^.lemma) and (ltmp^.parem <> nil) then ltmp := ltmp^.parem
    else
    begin
      result := false; exit;
    end;
  until false;
end;


//
// ==========================================================
// ==========================================================
//


function klapp_edasi (sqna, rg : string; p : word; lqpp : boolean) : boolean;
var
  cs, cr : char;
  i, j, slen : word;
begin
  slen := length (sqna);
  result := false;
  j := 0;
  for i := 1 to length (rg) do
  begin
    cr := rg[i];
    if not (cr in ['+','_','=','?']) then
    begin
      if p+j > slen then exit;
      cs := sqna[p+j];
      if (cr in ls_suurtxhed) then
      begin
        if not (cs in ls_klassid[cr]) then exit;
      end else if (cr <> '.') and (cs <> cr) then exit;
      inc (j);
    end;
  end;
  if lqpp and (p+j <= slen) then exit;
  result := true;
end;

function klapp_tagasi (sqna, rg : string; p : word; algus : boolean) : boolean;
var
  cs, cr : char;
  i, j : word;
begin
  result := false;
  j := p;
  for i := length(rg) downto 1 do
  begin
    cr := rg[i];
    if not (cr in ['+','_','=','?']) then
    begin
      if j = 0 then exit;
      cs := sqna[j];
      if (cr in ls_suurtxhed) then
      begin
        if not (cs in ls_klassid[cr]) then exit;
      end else if (cr <> '.') and (cs <> cr) then exit;
      dec (j);
    end;
  end;
  if algus and (j > 0) then exit;
  result := true;
end;

function piir_keelatud (jupp : string; p : word) : boolean;
var
  rg_num : word;
begin
  for rg_num := 1 to ls_rglube do
    if klapp_tagasi (jupp, ls_rgload[rg_num].r1, p-1, ls_rgload[rg_num].algus) and
       klapp_edasi (jupp, ls_rgload[rg_num].r2, p, ls_rgload[rg_num].lqpp) then
    begin
      result := false;
      exit;
    end;
  for rg_num := 1 to ls_keelde do
    if klapp_tagasi (jupp, ls_keelud[rg_num].r1, p-1, ls_keelud[rg_num].algus) and
       klapp_edasi (jupp, ls_keelud[rg_num].r2, p, ls_keelud[rg_num].lqpp) then
    begin
      result := true;
      exit;
    end;
  result := false;
end;

function fono_lubatud (s : string; algus, pikkus : word) : boolean;
var
  i : word;
  struk : string;
begin
  if pikkus <= 1 then begin result := false; exit end;
  i := 1;
  struk := copy (s, algus, pikkus);
  while (ls_fonoer[i] <> '') do
  begin
    if struk = ls_fonoer[i] then begin result := true; exit end;
    inc (i);
  end;
  if pikkus = 2 then begin result := false; exit end;

  for i := 1 to length(struk) do
    if struk[i] in ls_klassid['W'] then struk[i] := 'W' else struk[i] := 'C';
  if pos ('W', struk) = 0 then begin result := false; exit end;

  if (struk = 'CCW') or
     (struk = 'CCCW') or
     (struk = 'CWC') or
     (struk = 'CCWC') or
     (struk = 'CCCWC')
  then begin result := false; exit end;
  result := true;
end;

function pane_plussid (var jupp : string; rg : string; p : word) : boolean;
var
  i, ljupp : word;
begin
  result := false;
  ljupp := length (jupp);
  for i := length (rg) downto 1 do if rg[i] = '+' then
  begin
    if fono_lubatud (jupp, 1, p+i-2) and
       fono_lubatud (jupp, p+i-1, ljupp-p-i+2) and
       not piir_keelatud (jupp, p+i-1) then
    begin
      insert ('+', jupp, p+i-1);
      result := true;
    end;
  end;
end;

function rakenda_reegel (rg_num : word; var jupp : string) : boolean;
var
  i : word;
  rg : string;
  algus, lqpp : boolean;
begin
  result := false;
  rg := ls_kxsud[rg_num].r2;
  algus := ls_kxsud[rg_num].algus;
  lqpp := ls_kxsud[rg_num].lqpp;

  if (length(jupp) < length(rg)) then exit;

  if lqpp then
  begin
    i := length (jupp) - length (rg) + 1;
    if algus and (i <> 1) then exit;
    if klapp_tagasi (jupp, rg, length(jupp), algus) then
    begin
      if pane_plussid (jupp, ls_kxsud[rg_num].r1, i) then
      begin
        result := true;
        exit;
      end;
    end;
  end;

  for i := 1 to length(jupp) - length(rg) + 1 do
  begin
    if klapp_edasi (jupp, rg, i, lqpp) then
    begin
      if pane_plussid (jupp, ls_kxsud[rg_num].r1, i) then
      begin
        result := true;
        exit;
      end;
    end;
    if algus then exit;
  end;
end;

function proovi_poolreegleid (var jupp : string) : boolean;
var
  rg_num, i : integer;
  rg : string;
  algus, lqpp : boolean;
  kohad : set of byte;
begin
  result := false;
  kohad := [];

  for rg_num := 1 to ls_poolkxske do
  begin
    // vaatame lbi esimesed pooled e. ...mis? tpi reeglid
    if not (ls_poolkxsud[rg_num].r1[1] = '?') then
    begin
      rg := ls_poolkxsud[rg_num].r2;
      if (length(jupp) <= length(rg)) then continue;
      algus := ls_poolkxsud[rg_num].algus;
//      lqpp := ls_poolkxsud[rg_num].lqpp;

      for i := length(rg) to length(jupp) do
      begin
        if klapp_tagasi (jupp, rg, i, algus) then kohad := kohad + [i+1];
        if algus then break;
      end;
    end;
  end;

  if kohad = [] then begin result := false; exit; end;

  for rg_num := 1 to ls_poolkxske do
  begin
    // vaatame lbi tagumised pooled e. ?masin tpi reeglid
    if (ls_poolkxsud[rg_num].r1[1] = '?') then
    begin
      rg := ls_poolkxsud[rg_num].r2;
//      algus := ls_poolkxsud[rg_num].algus;
      lqpp := ls_poolkxsud[rg_num].lqpp;

      for i := 1 to length(jupp)-length(rg)+1 do
      begin
        if (i in kohad) and klapp_edasi (jupp, rg, i, lqpp) then
        begin
          insert ('+', jupp, i);
          result := true;
          exit;
        end;
      end;
    end;
  end;
end;

{
  Result tleb, kas plusse lisandus.
  Vajalik eeskxtt selleks, et erandeid edasi ei jupitataks.
}
function lisa_plussid (var jupp : string) : boolean;
var
  rg_num : word;
begin
  result := false;

  for rg_num := 1 to ls_erandeid do
    if pos (ls_erandid[rg_num].r2, jupp) = 1 then
    begin
      jupp := ls_erandid[rg_num].r1 +
        copy(jupp, length(ls_erandid[rg_num].r2)+1, length(jupp));
      result := false;
      exit;
    end;

  for rg_num := 1 to ls_kxske do
    if rakenda_reegel (rg_num, jupp) then
    begin
      result := true; exit;
    end;

  if (ls_sygavus > 1) and proovi_poolreegleid (jupp) then
  begin
    result := true; exit;
  end;
end;

function plusstsykkel (sqna : string) : string;
var
  jupp1, jupp2 : string;
  i : word;
begin
{
  + sisendis jb alles ja thistab liitsna piiri
  Lisanduvad reeglite poolt pandud plussid.
  lisa_plussid on false nii jaotumatu kui erandliku sqna puhul.
}
  i := pos ('+', sqna);
  if i > 0 then
  begin
    jupp1 := copy (sqna, 1, i-1);
    jupp2 := copy (sqna, i+1, length(sqna));
    if lisa_plussid (jupp1)
      then result := plusstsykkel (jupp1) + '+' + plusstsykkel (jupp2)
      else result := jupp1 + '+' + plusstsykkel (jupp2);
  end
  else
  begin
    jupp1 := sqna;
    jupp2 := '';
    if lisa_plussid (jupp1)
      then result := plusstsykkel (jupp1)
      else result := jupp1;
  end;
end;

// =====================================================

procedure loe_ls_fonoerandid;
var
  s : string;
  i : 1..ls_maxfonoer;
begin
  for i := 1 to ls_maxfonoer do ls_fonoer[i] := '';
  s := otsi_faili (lsfonoer_fail);
  if s = '' then
  begin
    ls_fonoer[1] := 'ei';
    ls_fonoer[2] := 'ea';
    ls_fonoer[3] := 'au';
    ls_fonoer[4] := 'e';
    ls_fonoer[5] := 'ao';
    ls_fonoer[6] := 'oa';
    ls_fonoer[7] := 'eo';
    ls_fonoer[8] := 'i';
    ls_fonoer[9] := 'u';
    ls_fonoer[10] := '';
    ls_fonoer[11] := 'mis';
    ls_fonoer[12] := 'kus';
    i := 13;
  end
  else
  begin
    assign (f, s); reset (f);
    i := 1;
    while not eof (f) do
    begin
      readln (f, s);
      trim (s);
      if (s <> '') and not (s[1] in [';','#']) and (i <= ls_maxfonoer) then
      begin
        ls_fonoer[i] := s;
        inc (i);
      end;
    end;
    closefile (f);
  end;
  lisarida ('... max '+inttostr(ls_maxfonoer)+', kasutatud '+inttostr(i-1));
end;

procedure lisa_kxskkeeld
 (var reeglid : ls_reeglimassiiv; var kk : word; r : string);
begin
{ REEGLITES ESINEVAD METASMBOLID:
  ^ sna algus
  $ sna lpp
  . suvaline tht
  + liitsna piir
  ? poolpiir - muutub plussiks kui leidub veel teine seda kinnitav ?
  = piiri lubamine, keelud jvad lbi vaatamata
  _ liitsnapiiri keeld
  A..Z, - defineeritud klassid
}
  inc (kk);
  if kk > ls_maxreegel then exit;

  if r[length(r)] = '$' then
  begin
    delete (r, length(r), 1); reeglid[kk].lqpp := true
  end
  else reeglid[kk].lqpp := false;

  if r[1] = '^' then
  begin
    delete (r, 1, 1); reeglid[kk].algus := true
  end
  else reeglid[kk].algus := false;

{
  Kskiv, pookkskiv ja erandlik reegel: r1 = reegel, r2 = puhastatud reegel
}
  if (@reeglid = @ls_erandid) or
     (@reeglid = @ls_kxsud) or
     (@reeglid = @ls_poolkxsud)
  then
  begin
    reeglid[kk].r1 := r;
    while pos ('+', r) > 0 do delete (r, pos ('+', r), 1);
    while pos ('?', r) > 0 do delete (r, pos ('?', r), 1);
    reeglid[kk].r2 := r;
  end
  else
{
  Keelaval ja lubaval ja  reeglil r1 = reegli vasak pool, r2 = parem pool
}
  if @reeglid = @ls_keelud then
  begin
    reeglid[kk].r1 := copy (r, 1, pos('_',r)-1);
    reeglid[kk].r2 := copy (r, pos('_',r)+1, length (r));
  end
  else
  if @reeglid = @ls_rgload then
  begin
    reeglid[kk].r1 := copy (r, 1, pos('=',r)-1);
    reeglid[kk].r2 := copy (r, pos('=',r)+1, length (r));
  end;
end;

procedure lisa_reegel (r : string);
begin
  if r = '' then exit;
  if pos ('+', r) > 0 then lisa_kxskkeeld (ls_kxsud, ls_kxske, r) else
  if pos ('_', r) > 0 then lisa_kxskkeeld (ls_keelud, ls_keelde, r) else
  if pos ('=', r) > 0 then lisa_kxskkeeld (ls_rgload, ls_rglube, r) else
  if pos ('?', r) > 0 then lisa_kxskkeeld (ls_poolkxsud, ls_poolkxske, r);
end;

procedure reegel_juurde (p : pchar);
begin
  lisa_reegel (strpas (p));
end;

procedure loe_ls_reeglid;
var
  s : string;
begin
  ls_kxske := 0;
  ls_keelde := 0;
  ls_rglube := 0;
  ls_erandeid := 0;
  ls_poolkxske := 0;

  s := otsi_faili (lserandid_fail);
  if s <> '' then
  begin
    assign (f, s); reset (f);
    while not eof (f) do
    begin
      readln (f, s);
      if pos (' ', s) > 0 then s := copy (s, 1, pos(' ',s)-1);
      s := trim (s);
      if copy (s, 1, 5) = '*****' then break;
      if (s <> '') and not (s[1] in [';','[','#']) then
        lisa_kxskkeeld (ls_erandid, ls_erandeid, s);
    end;
    closefile (f);
  end;

  s := otsi_faili (lsreeglid_fail);
  if s <> '' then
  begin
    assign (f, s); reset (f);
    while not eof (f) do
    begin
      readln (f, s);
      trim (s);
      if copy (s, 1, 5) = '*****' then break;
      if (s <> '') and not (s[1] in [';','[','#']) then lisa_reegel (s);
    end;
    closefile (f);
  end;

  s := otsi_faili (lskompo_fail);
  if s <> '' then
  begin
    assign (f, s); reset (f);
    while not eof (f) do
    begin
      readln (f, s);
      trim (s);
      if copy (s, 1, 5) = '*****' then break;
      if (s <> '') and not (s[1] in [';','[','#']) then lisa_reegel (s);
    end;
    closefile (f);
  end;
end;

procedure loe_ls_klassid;
var
  s : string;
  c : char;
  i : integer;
begin
  for c := 'A' to '' do if c in ls_suurtxhed then ls_klassid[c] := [];
  ls_klassid['C'] := ['b','c','d','f','g','h','j','k','l','m','n'] +
                     ['p','q','r','s','','z','','t','v','w','x'];
  ls_klassid['W'] := ['a','e','i','o','u','','','','','y'];

  s := otsi_faili (charsini_fail);
  if s = '' then exit;
  assign (f, s); reset (f);

  while not eof (f) do
  begin
    readln (f, s);
    trim (s);
    if (s <> '') and (s[1] in ls_suurtxhed) then
    begin
      c := s[1];
      for i := 1 to length (s) do ls_klassid[c] := ls_klassid[c] + [s[i]];
      ls_klassid[c] := ls_klassid[c] - [' '];
    end;
  end;
  closefile (f);
end;

procedure sea_ls_sygavus (w : word);
begin
  ls_sygavus := w;
  if ls_sygavus = 0 then ls_sygavus := 2;
end;




//
// ==========================================================
// ==========================================================
//



{
-------------------------------------------------
YLAKOMADE initsialiseerimine: Rabelais' etc
-------------------------------------------------
}

(* YLAKOMA definitsioonid *)
type
  yk_line = record formatiiv, vormikood : string end;
var
  yk_arr : array [1..yk_maxline] of yk_line;

// ------------------------------------------------------------------

procedure loe_ylakoma;
var
  s : string;
  p : integer;
begin
  for p := 1 to yk_maxline do yk_arr[p].formatiiv := '';

  s := otsi_faili (ylatab_fail);
  if s = '' then exit;
  assign (f, s); reset (f);

  p := 1;
  while not eof (f) do
  begin
    readln (f, s);
    s := trim (s);
    if (s <> '') and not (s[1] in ['#', ';']) and (p <= yk_maxline) then
    begin
      if s[1] = ',' then s := '0' + s;
      yk_arr[p].formatiiv := copy (s, 1, pos(',', s)-1);
      delete (s, 1, pos(',', s));
      yk_arr[p].vormikood := s;
      inc (p);
    end;
  end;
  close (f);
end;



//
// ==========================================================
// ==========================================================
//


{
-------------------------------------------------
ANA-kirjete ajutine stekk
-------------------------------------------------
}

type
  aptr = ^arec;
  arec = record
           lipik : word;
           a : anablokk;
           anext : aptr;
         end;
var
  ap, ar, abase : aptr;
  uuslipik : word;

function a_lipik : word;
begin
  uuslipik := (uuslipik mod 64000) + 1;
  a_lipik := uuslipik;
end;

procedure a_push (var lipik : word; var a : anablokk);
begin
  if abase = nil then
  begin
    new (abase);
    abase^.lipik := lipik;
    abase^.a := a;
    abase^.anext := nil;
    exit;
  end;

  ap := abase;
  while (ap^.anext <> nil) and (ap^.lipik <> 0) do ap := ap^.anext;
  if ap^.lipik = 0 then
  begin
    ap^.lipik := lipik;
    ap^.a := a;
    exit;
  end;

  new (ar);
  ar^.lipik := lipik;
  ar^.a := a;
  ar^.anext := nil;
  ap^.anext := ar;
end;

procedure a_pop (var lipik : word; var a : anablokk);
begin
  ap := abase;
  while (ap <> nil) and (ap^.lipik <> lipik) do ap := ap^.anext;
  if (ap = nil) then lipik := 0 else
  begin
    a := ap^.a;
    ap^.lipik := 0;
  end;
end;

procedure a_clear;
begin
  ap := abase;
  while (ap <> nil) do
  begin
    ap^.lipik := 0;
    ap := ap^.anext;
  end;
end;

procedure a_size (var size : word);
begin
  ap := abase;
  size := 0;
  while (ap <> nil) do
  begin
    inc (size);
    ap := ap^.anext;
  end;
end;

procedure killaptr (p : aptr);
begin
  if p^.anext <> nil then killaptr (p^.anext) else dispose (p);
end;

procedure a_exit;
begin
  if abase <> nil then killaptr (abase);
end;


//
// ==========================================================
// ==========================================================
//


(*
   kontrollib konkreetse tingimuse lubatavust, nt.
   sqna=kavats, tingimus=ts
   ! on unaarve eitus ja kib ainult jrgneva smboli kohta
*)
function tt1 (sqna, tingimus : string) : boolean;
var
  i, j : integer;
  ci, cj : char;
  eitus, txheklapp : boolean;
begin
  i := length (tingimus);
  j := length (sqna);
  repeat
(* tingimus sai otsa ja siiamaani on klappinud -> OK *)
    if (i = 0) then begin tt1 := true; exit end;
    eitus := (i > 1) and (tingimus[i-1] = '!');
(*
   sna sai otsa, aga tingimus veel mitte -> FALSE
   va juht, kus tingimus = !VVV ja sna oli VV
*)
    if (j = 0) then begin tt1 := eitus; exit end;

    ci := tingimus[i];
    cj := sqna[j];

    txheklapp := (ci in ls_suurtxhed) and (cj in ls_klassid[ci]) or (ci = cj);
    if txheklapp xor eitus then
    begin
// kas see vi teine
// klappis ja pidigi vi ei klappinud ega pidanudki
      dec (i); dec (j); if eitus then dec (i);
    end
    else
    begin
// mlemad (klappis aga ei tohtinud)
// ei kumbki (ei klappinud aga pidi)
      tt1 := false; exit
    end;
  until false;
end;

(*
   (/ = OR) jagamine tingimustes
*)
function testi_tingimus (sqna, tingimus : string) : boolean;
var
  t : string;
  tt : boolean;
begin
  if tingimus = '' then testi_tingimus := true else
  if sqna = '' then testi_tingimus := false else
  begin
    tt := false;
    repeat
      if pos ('/', tingimus) > 0 then
      begin
        t := copy (tingimus, 1, pos ('/', tingimus)-1);
        delete (tingimus, 1, pos ('/', tingimus));
      end
      else
      begin
        t := tingimus; tingimus := '';
      end;
      tt := tt or tt1 (sqna, t);
    until (tingimus = '') or tt;
    testi_tingimus := tt;
  end;
end;

procedure removeaccents (var s : string; var k : kribud);
var
  j, b : byte;
begin
  for b := 1 to 6 do k[b] := 0;
  b := 6;
  for j := length (s) downto 1 do
    if s[j] in ['@', '+', '''', '.', '`', '?'] then
  begin
    if b > 0 then
    begin
      k[b] := ord(s[j]); dec (b);
      k[b] := j; dec (b);
      delete (s, j, 1);
    end;
  end;
end;


//
// ==========================================================
// ==========================================================
//


// der-erandid

type
  drtype =
  record
    tyypliik : string;       // 13_A
    derlemma : string;       // n'oor -> noor
    dertyvi : string;        // noori[m] -> noori
    erandvorm : string;      // noori[m] -> noorim
    derkood : string;        // IM_sA
    tingimus : char;         // * - regulaarse vormi asemel
                             // + - regulaarsele vormile lisaks
  end;
var
  dr_arr : array [1..derer_max] of drtype;

// failist der.exc -> srt
procedure tee_loe_dererand;
var
  ndx_fail : string;
  i, j : integer;
  tmp : drtype;
  s : string;
  k : kribud;
begin
  for i := 1 to derer_max do dr_arr[i].derlemma := '';

  ndx_fail := otsi_faili (derer_fail);
  if ndx_fail = '' then exit;

  assign (f, ndx_fail); reset (f);
  i := 1;
  while (i <= derer_max) and not eof (f) do
  begin
    readln (f, s);
    s := trim (s);
    if (s <> '') and not (s[1] in [';','#']) then
    begin
      j := pos (',', s);
      dr_arr[i].tyypliik := copy (s, 1, j-1);
      delete (s, 1, j);

      j := pos (',', s);
      dr_arr[i].derlemma := copy (s, 1, j-1);
      removeaccents (dr_arr[i].derlemma, k);
      delete (s, 1, j);
      if dr_arr[i].tyypliik >= '27'
        then dr_arr[i].derlemma := dr_arr[i].derlemma + 'ma';

      j := pos (',', s);
      dr_arr[i].dertyvi := copy (s, 1, j-1);
      delete (s, 1, j);
      removeaccents (dr_arr[i].dertyvi, k);

      dr_arr[i].erandvorm := dr_arr[i].dertyvi;
      j := pos ('[', dr_arr[i].dertyvi);
      if j > 0 then
      begin
        dr_arr[i].dertyvi := copy (dr_arr[i].dertyvi, 1, j-1);
        for j := length (dr_arr[i].erandvorm) downto 1 do
          if dr_arr[i].erandvorm[j] in ['[', ']', '''']
          then delete (dr_arr[i].erandvorm, j, 1);
      end;

      j := pos (',', s);
      dr_arr[i].derkood := copy (s, 1, j-1);
      j := length (s);
      dr_arr[i].tingimus := s[j];

// paneme dr_arr[i] kohe igesse kohta vahele
      j := i;
      while (j > 1) and (dr_arr[j].erandvorm < dr_arr[j-1].erandvorm) do
      begin
        tmp := dr_arr[j]; dr_arr[j] := dr_arr[j-1]; dr_arr[j-1] := tmp;
        dec (j);
      end;

      inc (i);
    end;
  end;
  close (f);
  lisarida ('... max '+inttostr(derer_max)+', kasutatud '+inttostr(i-1));

  ndx_fail := changefileext (ndx_fail, '.srt');
  assign (f, ndx_fail); rewrite (f);
  for i := 1 to derer_max do if dr_arr[i].derlemma <> '' then
  begin
    write (f, dr_arr[i].tyypliik, ',', dr_arr[i].derlemma, ',');
    write (f, dr_arr[i].dertyvi, ',', dr_arr[i].erandvorm, ',');
    writeln (f, dr_arr[i].derkood, ',', dr_arr[i].tingimus);
  end;
  close (f);
end;

// failist der.srt
procedure loe_dererand;
var
  ndx_fail : string;
  i, j : integer;
  s : string;
begin
  ndx_fail := changefileext (derer_fail, '.srt');
  ndx_fail := otsi_faili (ndx_fail);
  if ndx_fail <> '' then
  begin
    assign (f, ndx_fail); reset (f);
    for i := 1 to derer_max do dr_arr[i].derlemma := '';

    i := 1;
    while (i <= derer_max) and not eof (f) do
    begin
      readln (f, s);
      s := trim (s);
      if (s <> '') then
      begin
        j := pos (',', s); dr_arr[i].tyypliik := copy (s, 1, j-1); delete (s, 1, j);
        j := pos (',', s); dr_arr[i].derlemma := copy (s, 1, j-1); delete (s, 1, j);
        j := pos (',', s); dr_arr[i].dertyvi := copy (s, 1, j-1); delete (s, 1, j);
        j := pos (',', s); dr_arr[i].erandvorm := copy (s, 1, j-1); delete (s, 1, j);
        j := pos (',', s); dr_arr[i].derkood := copy (s, 1, j-1); delete (s, 1, j);
        dr_arr[i].tingimus := s[1];
      end;
      inc (i);
    end;
    close (f);
    lisarida ('... max '+inttostr(derer_max)+', kasutatud '+inttostr(i-1));
  end
  else
  begin
    lisarida ('Teen uue');
    tee_loe_dererand;
  end;
end;

function on_dererand (var a : anablokk) : boolean;
var
  i : integer;
begin
  on_dererand := false;
  i := 1;
  while (i <= derer_max) and (dr_arr[i].derlemma <> '') do
  begin
    if (a.x_vormilemma = dr_arr[i].erandvorm) then
    begin
      a.x_dertyvi := dr_arr[i].dertyvi;
      a.x_derkood := dr_arr[i].derkood;
      a.x_derlemma := dr_arr[i].derlemma;
      a.x_tyypliik := dr_arr[i].tyypliik;
      on_dererand := (dr_arr[i].tingimus = '*');
      vxlja_der (a);
      exit;
    end;
    inc (i);
  end;
end;

function tekkis_dererand (var a : anablokk) : boolean;
var
  i : integer;
begin
  i := 1;
  while (i <= derer_max) and (dr_arr[i].derlemma <> '') do
  begin
    if (a.x_derkood = dr_arr[i].derkood) and
       (a.x_tyypliik = dr_arr[i].tyypliik) and
// po a.lemma, a.x_derlemma lpus on verbil +ma
       (a.x_derlemma = dr_arr[i].derlemma) then
      begin
        tekkis_dererand := (dr_arr[i].tingimus = '*');
        exit;
      end;
    inc (i);
  end;
  tekkis_dererand := false;
end;

// Muutumatud

type
  idtype =
  record
    sqnavorm : string;
    sliik1, sliik2 : char;   (* max kaks snaliiki *)
  end;
var
  id : array [1..indekl_max] of idtype;
  idtop : word;

// seda ei kutsutagi!
procedure loe_muutumatud;
var
  i, j : integer;
  s : string;
  tmp : idtype;
begin
  for i := 1 to indekl_max do id[i].sqnavorm := '';
  idtop := 0;

  s := otsi_faili (indekl_fail);
  if s = '' then exit;
  assignfile (f, s); reset (f);

  i := 0;
  while (i < indekl_max) and not eof (f) do
  begin
    readln (f, s);
    if (s <> '') and not (s[1] in [';','#']) then
    begin
      inc (i);
      id[i].sliik1 := s[1];
      id[i].sliik2 := s[2];
      delete (s, 1, 2);
      id[i].sqnavorm := s;
    end;
  end;
  close (f);
  idtop := i;

  for i := 2 to idtop do
  begin
    j := i;
    while (j > 1) and (id[j].sqnavorm < id[j-1].sqnavorm) do
    begin
      tmp := id[j]; id[j] := id[j-1]; id[j-1] := tmp;
      dec (j);
    end;
  end;
end;

procedure vxljasta_muutumatud (a : anablokk);
var
  i, idmin, idmax : word;
begin
// kui snastik puudus
  if idtop = 0 then exit;

  idmin := 1; idmax := idtop;
  repeat
    i := (idmax+idmin) div 2;
    if (id[i].sqnavorm > a.sqna) then idmax := i else idmin := i;
  until idmin + 4 >= idmax;
  while (idmin > 1) and (id[idmin].sqnavorm = a.sqna) do dec (idmin);
  while (idmin <= idmax) and (id[idmin].sqnavorm <> '') do
  begin
    if (a.sqna = id[idmin].sqnavorm) then
    begin
      a.lemma := id[idmin].sqnavorm;
      vxlja_frm (a);
    end;
    inc (idmin);
  end;
end;


//
// ==========================================================
// ==========================================================
//


// ksikerandid

type
  yxtype =
  record
    tyypliik : string;       // 04_S
    vormilemma : string;     // sda
    vormityvi : string;      // sdan[t] -> sdan
    erandvorm : string;      // sdan[t] -> sdant
    vormikood : string;      // 3 lqpu vormikood ----101- vms
    tingimus : char;         // * - regulaarse vormi asemel
                             // + - regulaarsele vormile lisaks
                             // ! - homonmide loendist, anals vib lppeda
  end;
var
  yx : array [1..yksik_max] of yxtype;

procedure tee_loe_yksikerand;
var
  ndx_fail, ndx2_fail : string;
  i, j, av : integer;
  s : string;
  k : kribud;
  tmp : yxtype;
begin
  for i := 1 to yksik_max do yx[i].vormilemma := '';

  ndx_fail := otsi_faili (yksik_fail);
  assignfile (f, ndx_fail); reset (f);
  i := 1;
  while (i <= yksik_max) and not eof (f) do
  begin
    readln (f, s);
    s := trim (s);
    if (s <> '') and not (s[1] in [';','#']) then
    begin
      j := pos (',', s);
      yx[i].tyypliik := copy (s, 1, j-1);
      delete (s, 1, j);

      j := pos (',', s);
      yx[i].vormilemma := copy (s, 1, j-1);
      removeaccents (yx[i].vormilemma, k);
      delete (s, 1, j);
      if yx[i].tyypliik >= '27'
        then yx[i].vormilemma := yx[i].vormilemma + 'ma';

      j := pos (',', s);
      yx[i].vormityvi := copy (s, 1, j-1);
      delete (s, 1, j);
      removeaccents (yx[i].vormityvi, k);

      yx[i].erandvorm := yx[i].vormityvi;
      j := pos ('[', yx[i].vormityvi);
      if j > 0 then
      begin
        yx[i].vormityvi := copy (yx[i].vormityvi, 1, j-1);
        for j := length (yx[i].erandvorm) downto 1 do
          if yx[i].erandvorm[j] in ['[', ']', '|']
          then delete (yx[i].erandvorm, j, 1);
      end;

      j := pos (',', s);
      yx[i].vormikood := copy (s, 1, j-1);
      j := length (s);
      yx[i].tingimus := s[j];

// paneme yx[i] kohe igesse kohta vahele
      j := i;
      while (j > 1) and (yx[j].erandvorm < yx[j-1].erandvorm) do
      begin
        tmp := yx[j]; yx[j] := yx[j-1]; yx[j-1] := tmp;
        dec (j);
      end;

      inc (i);
    end;
  end;
  close (f);

  av := ana_vorm;
  ana_vorm := 1;
  ndx2_fail := otsi_faili (yksik2_fail);
  assignfile (f, ndx2_fail); reset (f);
  while (i <= yksik_max) and not eof (f) do
  begin
    readln (f, s);
    s := trim (s);
    if (s <> '') and not (s[1] in [';','#']) then
    begin
      j := pos (' ', s);
      yx[i].erandvorm := copy (s, 1, j-1);
      delete (s, 1, j);

      delete (s, 1, 1);
      j := pos (' ', s);
      yx[i].vormityvi := copy (s, 1, j-1);
      delete (s, 1, j);

      delete (s, 1, 2);
      j := pos (' ', s);
      yx[i].vormikood := copy (s, 1, j-1);
      delete (s, 1, j);

      for j := 1 to maxvormikood do
      begin
        if (vormikoodid[j][2] = yx[i].vormikood)
          then yx[i].vormikood := vormikoodid[j,1];
        if (vormikoodid[j][3] = yx[i].vormikood)
          then yx[i].vormikood := vormikoodid[j,1];
        if (vormikoodid[j][2]+'^' = yx[i].vormikood)
          then yx[i].vormikood := vormikoodid[j,1]+'^';
        if (vormikoodid[j][3]+'^' = yx[i].vormikood)
          then yx[i].vormikood := vormikoodid[j,1]+'^';
      end;

      delete (s, 1, 2);
      j := pos (' ', s);
      yx[i].vormilemma := copy (s, 1, j-1);
      delete (s, 1, j);

      delete (s, 1, 1);
      yx[i].tyypliik := s;

      yx[i].tingimus := '!';

// paneme yx[i] kohe igesse kohta vahele
      j := i;
      while (j > 1) and (yx[j].erandvorm < yx[j-1].erandvorm) do
      begin
        tmp := yx[j]; yx[j] := yx[j-1]; yx[j-1] := tmp;
        dec (j);
      end;

      inc (i);
    end;
  end;
  close (f);
  ana_vorm := av;

  lisarida ('... max '+inttostr(yksik_max)+', kasutatud '+inttostr(i-1));

  ndx_fail := changefileext (ndx_fail, '.srt');
  assign (f, ndx_fail); rewrite (f);
  for i := 1 to yksik_max do if yx[i].vormilemma <> '' then
  begin
    write (f, yx[i].tyypliik, ',', yx[i].vormilemma, ',');
    write (f, yx[i].vormityvi, ',', yx[i].erandvorm, ',');
    writeln (f, yx[i].vormikood, ',', yx[i].tingimus);
  end;
  close (f);
end;

// failist form.srt
procedure loe_yksikerand;
var
  ndx_fail : string;
  i, j : integer;
  s : string;
begin
  ndx_fail := changefileext (yksik_fail, '.srt');
  ndx_fail := otsi_faili (ndx_fail);
  if ndx_fail <> '' then
  begin
    assign (f, ndx_fail); reset (f);
    for i := 1 to yksik_max do yx[i].vormilemma := '';

    i := 1;
    while (i <= yksik_max) and not eof (f) do
    begin
      readln (f, s);
      s := trim (s);
      if s <> '' then
      begin
        j := pos (',', s); yx[i].tyypliik := copy (s, 1, j-1); delete (s, 1, j);
        j := pos (',', s); yx[i].vormilemma := copy (s, 1, j-1); delete (s, 1, j);
        j := pos (',', s); yx[i].vormityvi := copy (s, 1, j-1); delete (s, 1, j);
        j := pos (',', s); yx[i].erandvorm := copy (s, 1, j-1); delete (s, 1, j);
        j := pos (',', s); yx[i].vormikood := copy (s, 1, j-1); delete (s, 1, j);
        yx[i].tingimus := s[1];
      end;
      inc (i);
    end;
    close (f);
    lisarida ('... max '+inttostr(yksik_max)+', kasutatud '+inttostr(i-1));
  end
  else
  begin
    lisarida ('Teen uue');
    tee_loe_yksikerand;
  end;
end;

// failist form.exc ja form2.exc

function on_yksikerand (a : anablokk) : boolean;
var
  i, step : integer;
  s : string;
begin
  result := false;
// kasutame teadmist, et fail on sorteeritud
  i := 1;
  step := yksik_max div 2;
  repeat
    if i + step > yksik_max then step := step div 2
    else
    begin
      s := yx[i+step].erandvorm;
      if (s <> '') and (s < a.sqna) then i := i + step else step := step div 2;
    end;
  until step < 4;

  while (i <= yksik_max) and
        (yx[i].vormilemma <> '') and
        (yx[i].erandvorm < a.sqna) do
  inc (i);

  while (i <= yksik_max) and
        (yx[i].vormilemma <> '') and
        (a.sqna = yx[i].erandvorm) do
  begin
    a.x_vormityvi := yx[i].vormityvi;
    a.x_vormikood := yx[i].vormikood;
    a.x_vormilemma := yx[i].vormilemma;
    a.x_tyypliik := yx[i].tyypliik;
// Kui humrke on, siis jrelikult olid homonmid kirjas
// failis form2.exc ja analsi vib siinkohal lpetada.
// Kui trn, siis see vorm on niikuinii ainus?
// teoreetiliselt peaks siin olema result := true alati
//    result := result or not (yx[i].tingimus = '+');
    result := true;
    vxlja_frm (a);
    inc (i);
  end;
// kuniks Ylle pole kiki vorme kirja pannud, vljastame false.
// muidu ei leita mulle = mull, neid = neiu jms.
//  result := false;
end;

(*
   KITUMISMALL:
     Keegi juba analsis, kuid tulemus vib vale olla.
     Kui antud lemma ja koodi jaoks on toodud teine vorm, tuleb kogu
     ana tulemust ignoreerida, muidu paneme a vljundisse.
     Ka tohib panna vljundisse kui rida 40 on & -- mlemad lubatud.
     (LU 'anals' --> LU + osastav on vale, sest loendis on LUT)
*)

function tekkis_yksikerand (var a : anablokk) : boolean;
var
  i : integer;
begin
  i := 1;
  while (i <= yksik_max) and (yx[i].vormilemma <> '') do
  begin
// lemma+vormi+tyybi+liigi jaoks on olemas erandvorm(e)
    if (a.x_vormikood = yx[i].vormikood) and
       (a.x_vormilemma = yx[i].vormilemma) and
       (a.x_tyypliik = yx[i].tyypliik) then
    begin
      tekkis_yksikerand := (yx[i].tingimus = '*');
      exit;
    end;
    inc (i);
  end;
  tekkis_yksikerand := false;
end;

procedure uusanablokk (var a : anablokk);
begin
  with a do
  begin
    sqna := '';
    tyvi := '';
    lqpp := '0';
    lemma := '';
    tyvekood := '';
    x_giki := false;
  end;
end;


//
// ==========================================================
// ==========================================================
//



{
-------------------------------------------------
DER-TAB ttlus
-------------------------------------------------
}

type
  derptrtype = ^derrectype;
  derrectype =
  record
    sufiks, info, tingimus, tyvelqpp, tyybid : string;
    dernext : derptrtype;
  end;
var
  dp, dr, derbase : derptrtype;

procedure der_init;
var
  s : string;
  i : integer;
begin
  derbase := nil;
  s := otsi_faili (dertab_fail);
  if s = '' then exit;
  assign (f, s); reset (f);
  while not eof (f) do
  begin
    readln (f, s);
    s := trim (s);
    if (s <> '') and not (s[1] in [';','#']) then
    begin
      new (dr);
      if derbase = nil then derbase := dr else dp^.dernext := dr;
      dp := dr;
      i := pos (',', s); dr^.sufiks := copy (s, 1, i-1); delete (s, 1, i);
      i := pos (',', s); dr^.info := copy (s, 1, i-1); delete (s, 1, i);
      i := pos (',', s); dr^.tingimus := copy (s, 1, i-1); delete (s, 1, i);
      dr^.tyybid := s;
      dr^.dernext := nil;
    end;
  end;
  close (f);

(*
  asendame '='-ga viidatud tvekoodid tegeliku loendiga
*)
  dp := derbase;
  while dp <> nil do
  begin
    i := pos ('-', dp^.tingimus);
    if i > 0 then
    begin
      dp^.tyvelqpp := copy (dp^.tingimus, i+1, 40);
      delete (dp^.tingimus, i, 40);
    end else dp^.tyvelqpp := '';

    if dp^.tyybid[1] = '=' then
    begin
      dr := derbase;
      while dr <> nil do
      begin
        if dp^.tyybid = '=' + dr^.sufiks + ',' + dr^.info
          then dp^.tyybid := dr^.tyybid;
        dr := dr^.dernext;
      end;
    end;
    dp := dp^.dernext;
  end;
end;

procedure killdptr (p : derptrtype);
begin
  if p^.dernext <> nil then killdptr (p^.dernext) else dispose (p);
end;

procedure der_exit;
begin
  killdptr (derbase);
end;


//
// ==========================================================
// ==========================================================
//


{
-------------------------------------------------
FORM-TAB ttlus
-------------------------------------------------
}

(* FORMTAB definitsioonid *)
type
  formtyyp = record
               formatiiv,
               vorm, tingimus, baasvorm,
               klassid : string;
             end;
var
  form_arr : array [1..form_maxline] of formtyyp;

// ------------------------------------------------------------------

procedure form_init;
var
  s : string;
  i, p : integer;
begin
  s := otsi_faili (formtab_fail);
  if s = '' then exit;
  assign (f, s); reset (f);

  p := 1;
  while not eof (f) do
  begin
    readln (f, s);
    if (s <> '') and (s[1] <> ';') then
    begin
// siin sees kasutame thja lpu thistusena '0'
      if s[1] = ',' then s := '0' + s;
      if p <= form_maxline then
      begin
        i := pos(',', s);
        form_arr[p].formatiiv := copy (s, 1, i-1);
        delete (s, 1, i);
        i := pos(',', s);
        form_arr[p].vorm := copy (s, 1, i-1);
        delete (s, 1, i);
        i := pos(',', s);
        form_arr[p].tingimus := copy (s, 1, i-1);
        delete (s, 1, i);
// baasvormi ja klassid parandame eraldi tsyklis
        form_arr[p].baasvorm := form_arr[p].vorm;
        form_arr[p].klassid := s;
        inc (p);
      end;
    end;
  end;
  close (f);
  lisarida ('... max '+inttostr(form_maxline)+', kasutatud '+inttostr(p-1));

  while p <= form_maxline do
  begin
    form_arr[p].formatiiv := ''; inc (p);
  end;

(*
   form-tab jrjestus on: lqpp, vormikood, eeltingimus, loend
      loend on tyvefail[,tyvefail] vi
               =lqpp, baasvormikood
   need viimased asendamegi kohe ige loendiga
   lisame uue vlja 'baasvormikood' vormikoodi ette:
      phivormidel (-b) vrdub see vormikoodiga,
      viitadel (-d = -b) tuleb phivormi kljest.
*)

  p := 1;
  repeat
    s := form_arr[p].klassid;
    if pos ('=', s) = 1 then
    begin
      delete (s, 1, 1);
      if s[1] = ',' then s := '0' + s;

      i := pos (',', s);
      form_arr[p].baasvorm := copy (s, i+1, 255);
      delete (s, i, 255);

      i := 0;
      repeat
        inc (i)
      until (i > form_maxline) or
        (s = form_arr[i].formatiiv) and
        (form_arr[p].baasvorm = form_arr[i].vorm);
      if i > form_maxline
        then lisarida ('vale viit formtabis: ' + s)
        else form_arr[p].klassid := form_arr[i].klassid;
    end;
    inc (p);
  until p = form_maxline;
end;


//
// ==========================================================
// ==========================================================
//


// Sagedased

type
  frqtype = record
              frq : longint;
              sqnavorm, vxljund : string;
            end;
var
  frqptr : array [1..frq_max] of frqtype;

// htlasi jrjestame, edaspidi tulevad lisagedased enne
procedure frq_purge;
var
  i, j : 1..frq_max;
  tmp : frqtype;
begin
  for i := 1 to frq_max do
    if frqptr[i].frq < 3 then frqptr[i].frq := 0;
  for i := 2 to frq_max do
  begin
    j := i;
    while (j > 1) and (frqptr[j].frq > frqptr[j-1].frq) do
    begin
      tmp := frqptr[j]; frqptr[j] := frqptr[j-1]; frqptr[j-1] := tmp;
      dec (j);
    end;
  end;
end;

// ei kontrolli, kas on juba olemas... usaldus, mis muud
procedure frq_add (s1, s2 : string);
var
  i : 1..frq_max;
begin
  if frqptr[frq_max].frq > 0 then frq_purge;
  for i := 1 to frq_max do
  begin
    if frqptr[i].frq = 0 then
    begin
      frqptr[i].frq := 1;
      frqptr[i].sqnavorm := s1;
      frqptr[i].vxljund := s2;
      exit;
    end;
{
    if frqptr[i].sqnavorm = s1 then
    begin
      frqptr[i].vxljund := s2;
      exit;
    end;
}
  end;
end;

procedure frq_clear;
var
  i : 1..frq_max;
begin
  for i := 1 to frq_max do frqptr[i].frq := 0;
// nii vib alati kindel olla, et thi sna saab thja vastuse
  frq_add ('', '');
end;

// Iga otsing suurendab tabamuse korral sagedust 1 vrra
function frq_find (s : string) : longint;
var
  i : 1..frq_max;
begin
  for i := 1 to frq_max do
  begin
    if frqptr[i].frq = 0 then begin result := 0; exit end;
    if frqptr[i].sqnavorm = s then
    begin
      inc (frqptr[i].frq); result := i; exit
    end;
  end;
  result := 0;
end;

function frq_out (ndx : longint) : string;
begin
  result := frqptr[ndx].vxljund;
end;

//
// ==========================================================
// ==========================================================
//


// -------------------------------------------------- //

procedure loe_vormikoodid;
var
  s : string;
  i, j : integer;
begin
  for i := 1 to maxvormikood do
    for j := 1 to maxvormiliik do
      vormikoodid[i][j] := '--------';

  s := otsi_faili (fcodesini_fail);
  if s = '' then exit;
  ana_vorm_loetud := true;
  assign (f, s); reset (f);
  i := 1;
  while not eof (f) do
  begin
    readln (f, s);
    s := trim (s);
    if (i < maxvormikood) and (s <> '') and not (s[1] in [';','@']) then
    begin
      j := pos (',', s);
      vormikoodid[i,2] := copy (s, 1, j-1);
      delete (s, 1, j);
      j := pos (',', s);
      vormikoodid[i,3] := copy (s, 1, j-1);
      delete (s, 1, j);
      j := pos (',', s);
      vormikoodid[i,1] := copy (s, 1, j-1);
      delete (s, 1, j);
      vormikoodid[i,4] := s;
      inc (i);
    end;
  end;
  close (f);
end;



//
// ==========================================================
// ==========================================================
//





function hakityyp (var tlstring, typus, licus, fumus : string) : boolean;
var
  i : integer;
begin
  if (fumus = '') or not (fumus[1] in ['0'..'9']) or
    (length(fumus) < 4) then
  begin
    result := false; exit;
  end;

//  fumus := stringreplace (fumus, '11_S~09_S', '80_S', []);

  i := 0;
  repeat inc(i) until (i > length(fumus)) or (fumus[i] in ['|', '~', '?']);
  tlstring := copy (fumus, 1, i-1);
  delete (fumus, 1, i);
  typus := copy (tlstring, 1, 2);
  licus := copy (tlstring, 4, 255);
  result := true;
end;

procedure clemmasplitter (var clemmarida, jupp : string);
var
  i : integer;
begin
(*
  variandid: lemma, 0, #, lemma|lemma, lemma(...)
  ...eks ma kustutan lihtsalt ra.
*)
  i := pos ('|', clemmarida);
  if i > 0 then
  begin
    jupp := copy (clemmarida, 1, i-1); delete (clemmarida, 1, i)
  end
  else
  begin
    jupp := clemmarida; clemmarida := '';
  end;
  i := pos ('(', jupp);
  if i > 0 then jupp := copy (jupp, 1, i-1);
end;

var
  ftptr : integer;
  ftvormid, fttyybid : array [0..9] of string;
procedure kutsu_findtypes (var vorm, tyybid : string);
var
  p : array [0..81] of char;
  i : integer;
begin
  for i := 0 to 9 do if ftvormid[i] = vorm then
  begin
    tyybid := fttyybid[i];
    exit;
  end;
  ftptr := (ftptr + 1) mod 10;
// viimane 0 - ilma vltemrgita
  findtypes (pchar(vorm), p, 80, 0);
  tyybid := p;
  ftvormid[ftptr] := vorm;
  fttyybid[ftptr] := tyybid;
end;

(*
   suuname a lemmakontrolli
   jsl on der-tab'i rea lpust
*)
procedure gen_der_lemma (a : anablokk; jsl : char);
var
  tk : integer;
  x, clvastus, typus, licus : string;
  p, p1, p2, p3 : array [0..255] of char;
begin
  strpcopy (p1, a.tyvi);
  // tyvekood der-tabist
  strpcopy (p2, copy (a.tyvekood,3,3));
  tk := strtoint (copy(a.tyvekood,1,2));

  createlemma (p1, tk, p2, p, 250, p3, 250, 0);
  clvastus := p;
  // vastused 0 ja # meid ei huvita
  if (length(clvastus) <= 1) then exit;

  repeat
    clemmasplitter (clvastus, x);
    a.lemma := x;

    if (tk in [27..40]) then x := x + 'ma';
    a.x_derlemma := x;

// Sisendina eeldatakse eestikeelse sna vikethtedega algvormi
// ainsuse nimetav / ma-tegevusnimi. Vljund koosneb omavahel
// alakriipsuga (_) eraldatatud muuttbi numbrist ning snaliigi
// thisest. Kui ks sna vib muutuda kahe erineva muuttbi jrgi,
// poodiumi vi poodiumit vahel seisab tilde (~), juhul kui ks
// tpidest loetakse phitbiks ja teine ksitavaks, on ksimrk (?).
// Kui snad on algvormis hesugused, eraldatakse tulemused
// pstkriipsuga (|).
//
// Sisendsna kallama: 29_V
// Sisendsna koer (kaks paralleeltpi): 23_SA?22_SA
// Sisendsna ehe (homograafiline): 05_S|06_S|02_A

//    findtypes (pchar(x), p1, 80);
//    x := p1;
    kutsu_findtypes (a.x_derlemma, x);

    while hakityyp (a.x_tyypliik, typus, licus, x) do
    begin
      // tyvekood der-tabist
      if typus = copy (a.tyvekood,1,2) then
      begin
        if (length (licus) > 0) and
           (jsl = licus[1]) and
           not tekkis_dererand (a) and
// tuletusalus PEAB olema snastikus
           on_lemma (a.x_derlemma, a.x_tyypliik) then
        begin
          if not ana_formatiiv_vxljastati then
          begin
// kasutame ajutiselt stringi hoidmiseks. sorry
            ana_a_enne_tuletust.x_derlemma := ana_sisendsqna;
            ana_sisendsqna := '?' + ana_sisendsqna;
            vxlja_frm (ana_a_enne_tuletust);
            ana_sisendsqna := ana_a_enne_tuletust.x_derlemma;
          end;
          vxlja_der (a);
          leitud := true;
        end;
      end;
    end;
  until clvastus = '';
end;

(*
  s on dertabi tyybirida, mille lpus on jreltingimus ,%sl:
  kxiame tsyklis lxbi lubatud tyvekoodide
  a ei tohi olla var
*)
procedure der_lem_cyk (a : anablokk; s : string);
var
  jsl : char;
begin
  jsl := s[pos('%',s)+1];
  while s[1] <> '%' do
  begin
    a.tyvekood := copy (s, 1, pos(',',s)-1);
    delete (s, 1, pos(',',s));
//    if (a.tyvekood[3] = '_') then vxlja_der (a) else
//    if (a.tyvekood = '41') then vxlja_der (a) else
    gen_der_lemma (a, jsl);
  end;
end;

procedure dertab_otsi (var a : anablokk; tyv, suf : string);
var
  alg_a : anablokk;
begin
  alg_a := a;
  dp := derbase;
  while dp <> nil do
  begin
    if (dp^.sufiks = suf) and testi_tingimus (tyv, dp^.tingimus)
    then
    begin
      a.x_dertyvi := tyv + dp^.tyvelqpp;
      a.tyvi := tyv + dp^.tyvelqpp;
      a.x_derkood := dp^.info;
//      a.formatiiv := '.' + dp^.sufiks + ',' + alg_a.formatiiv;
// SAADAME SOBIVA TULETUSE KONTROLLI
      der_lem_cyk (a, dp^.tyybid);
      a := alg_a;
    end;
    dp := dp^.dernext;
  end;
end;

procedure dertab_haki (a : anablokk);
var
  i, j : word;
  tyv, suf : string;
begin
  if not on_dererand (a) then
  begin
    // siin on nimelt a.x_vormilemmalemma, lpus on verbi infinitiivil 'ma'
    if length (a.x_vormilemma) > 9
      then i := length (a.x_vormilemma) - 8 else i := 2;
    for j := i to length (a.x_vormilemma)-1 do
    begin
      tyv := copy (a.x_vormilemma, 1, j);
      suf := copy (a.x_vormilemma, j+1, 255);
      dertab_otsi (a, tyv, suf);
    end;
  end;
end;

procedure gen_form_lemma (a : anablokk);
var
  tk : integer;
  x, clvastus, sonastikutyypliik, typus, licus : string;
  p, p1, p2, p3 : array [0..255] of char;
begin
  strpcopy (p1, a.tyvi);
  // tyvekood form-tabist
  strpcopy (p2, copy (a.tyvekood,3,3));
  tk := strtoint (copy(a.tyvekood,1,2));

  if tk = 41 then p := p1 else
  begin
{
    case tk of
      80 : tk := 9;
      81 : tk := 23;
    end;
}
    createlemma (p1, tk, p2, p, 250, p3, 250, 0);
//    lisarida ('crlemma: '+a.tyvi+' ('+a.tyvekood+') ->'+p);
  end;
  clvastus := p;
  // vastused 0 ja # meid ei huvita
  if (length(clvastus) <= 1) then exit;

  repeat
    clemmasplitter (clvastus, x);
    a.lemma := x;

    if (tk in [27..40]) then x := x + 'ma';
    a.x_vormilemma := x;

//    findtypes (pchar(x), p1, 80);
//    lisarida ('findtypes: '+x+' ->'+p1);
//    x := p1;
    kutsu_findtypes (a.x_vormilemma, x);

// hakityyp tagastab 11_09 asemel 80 etc

    while hakityyp (a.x_tyypliik, typus, licus, x) do
    begin
// siin keelame muutumatutele gi/ki otsapaneku
      if a.x_giki and (
        (pos ('I', licus) > 0) or (pos ('J', licus) > 0)
      ) then
      begin
//      lisarida ('findtypes IJ: ' + a.x_vormilemma);
      end
      else
      if typus = copy (a.tyvekood,1,2) then
      begin
        if not tekkis_yksikerand (a) then
        begin
          sonastikutyypliik :=
            tyypliik_lahku_esimeseks (a.x_tyypliik);

          // kontroll lemmasnastikust
          if not (ana_sqnastikuga or ana_fsmode) or
             ana_ykskqikmis or
             on_lemma (a.x_vormilemma, sonastikutyypliik) then
          begin
            ana_formatiiv_vxljastati := true;
            vxlja_frm (a);
            leitud := true;
          end
          else
          begin
// selle jrgi vljastatakse ka need formatiivid, mida
// pole snastikus, mis aga lubavad tuletise (nt hakkamine)
            ana_formatiiv_vxljastati := false;
            ana_a_enne_tuletust := a;
          end;
          if (ana_tuletusega or ana_fsmode) then dertab_haki (a);
        end;
      end;
    end;
  until clvastus = '';
end;

(*
   s on form_arr klasside rida, mis sisaldab ainult tyvekoode,
   kxiame tsyklis lxbi lubatud tyvekoodide
   a ei tohi olla var
*)
procedure form_formid (a : anablokk; s : string);
var
  i : integer;
begin
  s := s + ',';
  while s <> '' do
  begin
    i := pos(',', s);
    a.tyvekood := copy (s, 1, i-1);
    delete (s, 1, i);
//    lisarida (a.tyvekood);
    gen_form_lemma (a);
  end;
end;

(*
   p on formarr rea number, kus leidub sobiv lqpp
   a ei tohi olla var
*)
procedure form_lqpp_leitud (a : anablokk; p : word);
var
  tingimus : string;
begin
// siin keelame muutumatutele gi/ki otsapaneku
// kolis kipsmao jrele, enne ei tea snaliiki
//  if a.x_giki and (form_arr[p].vorm = '--------') then exit;

//  a.lqpp := form_arr[p].formatiiv;
  a.x_vormikood := form_arr[p].vorm;
  tingimus := form_arr[p].tingimus;

  if testi_tingimus (a.tyvi, tingimus) then
  begin
    form_formid (a, form_arr[p].klassid);
  end;
end;

// a ei ole var
procedure formtab_haki (a : anablokk);
var
  i, j, k, len : word;
  s : string;
begin
// on_yksikerand yhtlasi vljastab
  if not on_yksikerand (a) then
  begin
    s := a.sqna;
    len := length (s);
    if len > 9 then i := len - 8 else i := 2;
    for j := i to len do
    begin
      a.tyvi := copy (s, 1, j);
      a.x_vormityvi := a.tyvi;
      if j >= len then a.lqpp := '0' else a.lqpp := copy (s, j+1, 10);

      k := 1;
      repeat
        if a.lqpp = form_arr[k].formatiiv then form_lqpp_leitud (a, k);
        inc (k);
      until (k > form_maxline) or (form_arr[k].formatiiv = '');
    end;
  end;
end;


function jaguneb (jupp : string; var jagatud : string) : boolean;
var
  lsptr, i, j : word;
  s1, s2 : string;
  c : char;
begin
  lsptr := 1;
  j := length (jupp);
  c := jupp[1];

  while (lsptr <= ls_maxline) and
        (ls_arr[lsptr] <> '') and
        (ls_arr[lsptr][1] <> c) do
  inc (lsptr);

  while (lsptr <= ls_maxline) and
        (ls_arr[lsptr] <> '') and
        (ls_arr[lsptr][1] = c) do
  begin
    if pos (ls_arr[lsptr], jupp) = 1 then
    begin
      if ls_arr[lsptr] = jupp then
      begin
        jagatud := jupp;
        result := true;
        exit;
      end;
      i := length (ls_arr[lsptr]);
      if i <= j-2 then
      begin
        s1 := copy (jupp, i+1, j);
        if jaguneb (s1, s2) then
        begin
          jagatud := copy(jupp,1,i) + '+' + s2;
          result := true;
          exit;
        end;
      end;
    end;
    inc (lsptr);
  end;
  result := false;
end;

function jaguneb_vana (jupp : string; var jagatud : string) : boolean;
var
  i, j, len : word;
  sign : integer;
  s1, s2 : string;
begin
  if on_lskomp (jupp) then
  begin
    jagatud := jupp;
    result := true;
    exit;
  end;

  len := length (jupp);
  if len >= 4 then
  begin
    sign := 1;
    i := 0;
    j := len div 2;
    repeat
      if jaguneb(copy(jupp,1,j), s1) and jaguneb(copy(jupp,j+1,255), s2)
      then
      begin
        jagatud := s1 + '+' + s2;
        result := true;
        exit;
      end;
      inc (i);
      j := j + sign*i;
      sign := -sign;
    until (j = 1) or (j = len-1);
  end;
  result := false;
end;

function leia_lsosised (var jupp : string) : string;
var
  i, len : word;
  s : string;
begin
  len := length (jupp);
  if jaguneb (jupp, s) then
  begin
    result := s; exit;
  end;
// mida pikema liitsna esiosa saab, seda parem
  for i := len-2 downto 2 do
  if jaguneb (copy (jupp,1,i), s) then
  begin
    result := s + '+' + copy (jupp, i+1, len);
    exit;
  end;
  result := jupp;
end;


function on_liitmxxrsqna (a : anablokk) : boolean;
var
  i : integer;
begin
  result := false;
  i := liitmxxrsqnad.indexof (a.sqna);
  if (i >= 0) then
  begin
    a.x_tyypliik := tyllesodi(liitmxxrsqnad.objects[i]).tyypliik;
    if a.x_giki then
    begin
      if pos ('I', a.x_tyypliik) > 0 then exit;
      if pos ('J', a.x_tyypliik) > 0 then exit;
    end;
    a.x_vormityvi := a.sqna;
    a.x_vormilemma := tyllesodi(liitmxxrsqnad.objects[i]).puhastamata;
    a.x_vormikood := '--------';
    vxlja_frm (a);
    result := not tyllesodi(liitmxxrsqnad.objects[i]).jxtka;
  end;
end;


procedure liitsqna (a : anablokk);
var
  i, len : word;
  s, tmptulemus, tmpalgusots : string;
//  tmp_sqnastikuga : boolean;
  uusa : anablokk;
begin
  if on_liitmxxrsqna (a) then exit;

  formtab_haki (a);

  if not (ana_liitsqna or ana_fsmode) then exit;
  if (length (a.sqna) <= 4) then exit;

  ana_liitsqnaanalyys := true;

//  algusots := plusstsykkel (a.sqna);
//  tmp_sqnastikuga := ana_sqnastikuga;
//  ana_sqnastikuga := true;
  tmptulemus := tulemus;
  tmpalgusots := ana_algusots;
  tulemus := '';

  len := length (a.sqna);
  for i := len-2 downto 2 do
  if jaguneb (copy (a.sqna, 1, i), s) and
    fono_lubatud (a.sqna, i+1, len-i) and
    not piir_keelatud (a.sqna, i+1) then
  begin
    ana_esikomponendianalyys := true;
    esikomponendiandmed.clear;
    uusa := a;
    uusa.sqna := copy (a.sqna, 1, i);
    formtab_haki (uusa);
    ana_esikomponendianalyys := false;

    uusa := a;
    uusa.sqna := copy (a.sqna, i+1, len);
    ana_algusots := tmpalgusots + s + '+';
    formtab_haki (uusa);
  end;
  if not ((tulemus = '') or ana_fsmode)
    then tulemus := '# ---------- ' + crnl + tulemus;
  tulemus := tmptulemus + tulemus;
//  ana_sqnastikuga := tmp_sqnastikuga;
  ana_algusots := tmpalgusots;
  ana_liitsqnaanalyys := false;
end;


(*
  ki/gi eemaldamine
  Anals hargneb kaheks.
  uue form_lipiku kysimine on siin 2x, sest iga der-tsykkel nullib selle
*)
procedure giki (var a : anablokk);
var
  i : longint;
begin
//  form_lipik := a_lipik;
  liitsqna (a);

//  form_lipik := a_lipik;
  i := length (a.sqna);
  if (i >= 4) and
    ((a.sqna[i-2] in GI + ['''']) and (copy (a.sqna, i-1, 2) = 'gi')
     or
     not (a.sqna[i-2] in GI) and (copy (a.sqna, i-1, 2) = 'ki'))
  then
  begin
    a.x_giki := true;
    delete (a.sqna, i-1, 2);
    liitsqna (a);
  end;
end;

(*
   ylakomaga kndelpud
*)
function on_ylakoma (a : anablokk) : boolean;
var
  i, j : longint;
  s : string;
begin
  on_ylakoma := false;
  if pos ('''', a.sqna) > 0 then
  begin
    i := length (a.sqna) + 1;
    repeat dec(i) until a.sqna[i] = '''';
    s := copy (a.sqna, i+1, length(a.sqna));
    delete (a.sqna, i, length(a.sqna));

// NB! ylakoma failis pole yhtki gi ega ki-lpulist!

    j := length (s);
    if j >= 2 then
    begin
      if (copy (s, j-1, 2) = 'gi') then
      begin
        if (j > 2) and not (s[j-2] in GI) then exit;
        a.x_giki := true;
        delete (s, j-1, 2);
      end
      else
      if (copy (s, j-1, 2) = 'ki') then
      begin
        if (j > 2) and (s[j-2] in GI) then exit;
        a.x_giki := true;
        delete (s, j-1, 2);
      end;
    end;
    if s = '' then s := '0';

    for j := 1 to yk_maxline do if yk_arr[j].formatiiv = s then
    begin
      a.x_vormityvi := a.sqna;
      a.x_vormilemma := a.sqna;
      a.x_vormikood := yk_arr[j].vormikood;
      a.x_tyypliik := 'xx_Q';
      vxlja_frm (a);
      on_ylakoma := true;
    end;
  end;
end;

(*
   kriipsuga kndelpud. kasutame sama faili, mis lakomagi puhul
*)
function on_kriipsuga (a : anablokk) : boolean;
var
  i, j : longint;
  s : string;
begin
  result := false;
  s := a.sqna;
  i := length (s) + 1;
  repeat dec(i) until (i = 0) or (s[i] = '-');
  if i > 0 then
  begin
// "sqna-" on lubamatu kndelpp
    if i = length(s) then exit;
// tiira-taara jms
    if on_liitmxxrsqna (a) then begin result := true; exit; end;

    j := length (s);
    if j > 2 then
    begin
      if (copy (s, j-1, 2) = 'gi') then
      begin
        if not (s[j-2] in GI) then exit;
        a.x_giki := true;
        delete (s, j-1, 2);
      end
      else
      if (copy (s, j-1, 2) = 'ki') then
      begin
        if (s[j-2] in GI) then exit;
        a.x_giki := true;
        delete (s, j-1, 2);
      end;
    end;
    if s = '' then exit;

    a.sqna := s;
// tiira-taaragi jms
    if on_liitmxxrsqna (a) then begin result := true; exit; end;

    s := copy (a.sqna, i+1, length(a.sqna));
    delete (a.sqna, i, length(a.sqna));

// NB! ylakoma failis pole yhtki gi ega ki-lpulist!
// Poe-le jms
    for j := 1 to yk_maxline do if yk_arr[j].formatiiv = s then
    begin
      a.x_vormityvi := a.sqna;
      a.x_vormilemma := a.sqna;
      a.x_vormikood := yk_arr[j].vormikood;
      a.x_tyypliik := 'xx_Q';
      vxlja_frm (a);
      result := true;
    end;
  end;
end;

(*
  ylakomad, kriipsud, millele jrgneb gi/ki jaotus.
  s ei ole var
*)
procedure varlqpp (s : string);
var
  i : longint;
  a : anablokk;
begin
  if (s <> '') then
  begin
    uusanablokk (a);
//    s := ansilowercase (s);
    a.sqna := s;

// ylakoma vxrk kontrollib gi/ki-d ja vxljastab ise.
    if pos ('''', a.sqna) > 0 then
    begin
      if on_ylakoma (a) then exit;
      for i := length (s) downto 1 do if (s[i] = '''') then delete (s, i, 1);
      a.sqna := ansilowercase (s);
    end;

// kriipsuvxrk kontrollib gi/ki-d ja vxljastab ise.
    if pos ('-', a.sqna) > 0 then
    begin
      i := length (a.sqna) + 1;
      if a.sqna[i-1] = '-' then delete (a.sqna, i-1, 1) else
      begin
        if on_kriipsuga (a) then exit;
        repeat dec(i) until a.sqna[i] = '-';
        ana_algusots := copy (a.sqna, 1, i);
        delete (a.sqna, 1, i);
      end;
    end;

    giki (a);
  end;
end;

(*
  sodi eemaldamine. ylakomad ja kriipsud jvad.
*)
procedure puhasta (var s : string);
var
  i : longint;
begin
  for i := length (s) downto 1 do
  case s[i] of
    chr(138) : s[i] := chr(208);
    chr(154) : s[i] := chr(240);
    chr(141) : s[i] := chr(222);
    chr(142) : s[i] := chr(222);
    chr(157) : s[i] := chr(254);
    chr(158) : s[i] := chr(254);
    'A'..'Z','a'..'z',''..chr(255) : begin end;
    '`','' : s[i] := chr(39);
    '''','-' : begin end;
    else delete (s, i, 1);
  end;
  s := ansilowercase (s);
end;

function maskmatch (sqna, mask : string) : boolean;
const
  maxstates = 20;
var
  s : string;
  cset : set of char;
  i, matchcnt : integer;
begin
  result := false;
  if (mask = '') or (sqna = '') then exit;
  mask := mask + ' ';
  matchcnt := 1;
  while (matchcnt < maxstates) and (pos (' ', mask) > 0) do
  begin
    s := copy (mask, 1, pos (' ', mask)-1);
    delete (mask, 1, pos (' ', mask));
    cset := [];

    if s = 'roomanumbrid' then cset := ['I','V','X','L','C','D','M']
    else
    if s = 'araabianumbrid' then cset := ['0'..'9']
    else
    if s = 'thed' then cset := ['a'..'z','A'..'Z',#192..#255]
    else
    if s = 'suurthed' then cset := ['A'..'Z',#192..#223]
    else
    if s = 'vikethed' then cset := ['a'..'z',#224..#255]
    else for i := 1 to length (s) do cset := cset + [s[i]];

    i := 1;
    if sqna = '' then exit;
    while (i <= length(sqna)) and (sqna[i] in cset) do inc (i);
// tingimus: iga maski element peab snas esinema
    if i = 1 then exit;
//  matches[matchcnt] := copy (sqna, 1, i-1);
    delete (sqna, 1, i-1);
    inc (matchcnt);
  end;
  result := (sqna = '');
end;

(*
  kqiksugu sodi eemaldamine
*)
function onkribu (s : string) : boolean;
var
  a : anablokk;
begin
  result := false;

  if maskmatch (s, 'roomanumbrid') then
  begin
    ana_sisendsqna := s;
    uusanablokk (a);
    a.sqna := s;
    a.lqpp := '0';
    a.x_vormityvi := a.sqna;
    a.x_vormilemma := a.sqna;
    a.x_vormikood := '------xx';
    a.x_tyypliik := 'xx_O';
    vxlja_frm (a);
    result := true;
    exit;
  end;

  if maskmatch (s, 'thed') then exit;

  if maskmatch (s, 'araabianumbrid') or
     maskmatch (s, 'araabianumbrid - araabianumbrid') then
  begin
    ana_sisendsqna := s;
    uusanablokk (a);
    a.sqna := s;
    a.lqpp := '0';
    a.x_vormityvi := a.sqna;
    a.x_vormilemma := a.sqna;
    a.x_vormikood := '------xx';
    a.x_tyypliik := 'xx_N';
    vxlja_frm (a);
    result := true;
  end
  else
  if maskmatch (s, 'araabianumbrid .') then
  begin
    ana_sisendsqna := s;
    uusanablokk (a);
    a.sqna := s;
    a.lqpp := '0';
    a.x_vormityvi := a.sqna;
    a.x_vormilemma := a.sqna;
    a.x_vormikood := '------xx';
    a.x_tyypliik := 'xx_O';
    vxlja_frm (a);
    result := true;
  end;
end;


// ======================================================= //

procedure analyys (p : pchar; len : word); far stdcall export;
var
  i : longint;
  sisendstring : string;
begin
  if ana_hqivatud then
  begin
    strpcopy (p, '#:('); exit;
  end;
  ana_hqivatud := true;
// selline pring tagastab initsialiseerimisteated,
// aga ka viimati olnud vljundi
  if p = '?' then
  begin
    strlcopy (p, pchar(tulemus), len-1);
    ana_hqivatud := false;
    exit;
  end;

  tulemus := '';
  sisendstring := p;

  i := frq_find (sisendstring);
  if i > 0 then tulemus := frq_out (i) else
  begin
    if not onkribu (sisendstring) then
    begin
      puhasta (sisendstring);
      ana_sisendsqna := sisendstring;
      ana_algusots := '';
      varlqpp (sisendstring);
      if (tulemus = '') and (ana_sqnastikuga or ana_fsmode) then
      begin
        ana_ykskqikmis := true;
        varlqpp (sisendstring);
        ana_ykskqikmis := false;
      end;
      if (tulemus = '') then
        if ana_fsmode
          then tulemus := '    ' + p + '+0 //_Y_ ?, //' + crnl
          else tulemus := '### ' + p + crnl;
    end;
    frq_add (sisendstring, tulemus);
  end;
  strlcopy (p, pchar(tulemus), len-1);
  ana_hqivatud := false;
end;
exports analyys;

procedure tyybituvastus (p : pchar; len : word); far stdcall export;
var
  s, x : string;
begin
  s := p;
  kutsu_findtypes (s, x);
  strlcopy (p, pchar(x), len-1);
end;
exports tyybituvastus;

// ------------------------------------------------------------

procedure sea_vxljundvorm (i : word); far stdcall export;
begin
  if ana_vorm_loetud then
  begin
// seespidiselt kasutame 1..4
    inc (i);
    if (i <= maxvormiliik) then ana_vorm := i;
    ana_fsmode := (ana_vorm = 4);
    frq_clear;
  end;
end;
exports sea_vxljundvorm;

procedure sea_sqnastikuga (i : boolean); far stdcall export;
begin
  ana_sqnastikuga := i;
  frq_clear;
end;
exports sea_sqnastikuga;

procedure sea_tuletusega (i : boolean); far stdcall export;
begin
  ana_tuletusega := i;
  frq_clear;
end;
exports sea_tuletusega;

procedure sea_liitsqna (i : boolean); far stdcall export;
begin
  ana_liitsqna := i;
  frq_clear;
end;
exports sea_liitsqna;

// -------------------------------------------------------------

procedure ana_exit;
begin
  der_exit;
  lem_exit;
// tapame stekki jnud thjad anablokid
  a_exit;
// liitsqnapiirangud, keeletehnoloogia '99
  tervikliitsqnad.free;
  esikomponendiandmed.free;
  yhendverbiandmed.free;
  liitmxxrsqnad.free;
  liitsqnad1p.free;
  liitsqnad2p.free;

// lpuks taastame algse viida
  ExitProc := SaveExit;
end;

function get_ana_dir : string;
const
  buflen = 512;
var
  panadir : array [0..buflen] of char;
begin
  if GetEnvironmentVariable ('EST_MORPHO_DATA', panadir, buflen) > 0
    then result := panadir else result := '';
  if result <> '' then
  begin
    result := result + '\';
    result := stringreplace (result, '\\', '\', [rfreplaceall]);
  end;
end;

procedure ana_init;
begin
  filemode := $40;
  ana_fail_dir := get_ana_dir;
  loe_vormikoodid;
// edasi suvalises jrjekorras
//  loe_muutumatud;
  loe_dererand;
  loe_yksikerand;
  der_init;
  form_init;
  frq_clear;
  loe_ylakoma;
  loe_lskomp;
// liitsqnapiirangud, keeletehnoloogia '99
  loe_tervikliitsqna;
  loe_lemmad;
  loe_ls_klassid;
  loe_ls_fonoerandid;
  loe_ls_reeglid;
  filemode := 2;
end;

begin
  ana_hqivatud := true;
  ana_vorm_loetud := false;
  ana_init;
  ana_vorm := 1; { vaikimisi vljastame sisekoodi }
  ana_fsmode := false;
  ana_sqnastikuga := false;
  ana_tuletusega := true;
  ana_liitsqna := true;
  sea_ls_sygavus (0);
  SaveExit := ExitProc;
  ExitProc := @ana_exit;
  ana_hqivatud := false;
end.

