unit demo_unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, Gauges;

type
  TForm1 = class(TForm)
    sqna: TEdit;
    analyys: TButton;
    tulemus: TMemo;
    RadioGroup1: TRadioGroup;
    MainMenu1: TMainMenu;
    Fail1: TMenuItem;
    Ava1: TMenuItem;
    Lpeta1: TMenuItem;
    OpenDialog1: TOpenDialog;
    koostuletusega: TCheckBox;
    Gauge1: TGauge;
    koosliitsqnaga: TCheckBox;
    koossqnastikuga: TCheckBox;
    tuvastatyyp: TButton;
    paradigma: TButton;
    procedure analyysClick(Sender: TObject);
    procedure sqnaKeyPress(Sender: TObject; var Key: Char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Lpeta1Click(Sender: TObject);
    procedure Ava1Click(Sender: TObject);
    procedure koostuletusegaClick(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure koosliitsqnagaClick(Sender: TObject);
    procedure koossqnastikugaClick(Sender: TObject);
    procedure tuvastatyypClick(Sender: TObject);
    procedure paradigmaClick(Sender: TObject);
//    procedure paradigmaClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
  inf, outf : text;
  failist : boolean;
  fsmode : boolean; // emuleerime Filosofti vljundit

procedure analyys (p : pchar; len : word); far stdcall external 'ana.dll';
procedure tyybituvastus (p : pchar; len : word); far stdcall external 'ana.dll';
procedure syntees (p : pchar; len : word); far stdcall external 'ana.dll';
procedure sea_vxljundvorm (i : word); far stdcall external 'ana.dll';
procedure sea_sqnastikuga (i : boolean); far stdcall external 'ana.dll';
procedure sea_tuletusega (i : boolean); far stdcall external 'ana.dll';
procedure sea_liitsqna (i : boolean); far stdcall external 'ana.dll';

// NB! snteesi vljakutsumine delphist on tundlik kompilaatori
// vtmete suhtes. Vajalik on
// Aligned record fields - off e {A-}

type
  SynthForm =
  record
    vorm : array[0..29] of char;
    stemLength : integer;
  end;

type
  SynthFormSet =
  record
    tyybinumber : integer;
    sqnaliik : array[0..2] of char;
    variandinumber : integer;
    paralleelvorme : integer;
    vormikood : array[0..29] of char;
    vormid : array[0..4] of SynthForm;
  end;

Function SynthesizeForms
  (lemma : PChar; withApp : integer; codeType : integer;
   var outBuf : array of SynthFormSet; bufLength : integer) : integer;
   stdcall; external 'fmsynth.dll';


// ------------------------------------------------------------------

procedure analyysi (var s : string);
var
// reserveerime tulemuste stringile 4 kilobaiti (umbes kolmekordne varu,
// arvestades reaalses tekstis ette tulla vivate snavormidega).
  p : array [0..4096] of char;
begin
  if s = '' then exit;
  if (s = '$LA$') or (s = '$LL$') then
    s := '    ####' else
  if (s = '.') or (s = ',') or (s = '"') or
     (s = '...') or (s = ':') or (s = '-') or
     (s = '(') or (s = ')') or (s = '!') or (s = '?') or
     (s = ';') then
    s := '    ' + s + ' //_Z_ //' else
  // siin oleks mistlik veel sodi vlja puhastada.
  begin
    strlcopy (p, pchar(s), sizeof(p)-1);
    analyys (p, sizeof(p)-1);
    if (p <> '') then s := p
    else s := '    ' + s + '+0 //_Y_ ?, //'
  end;
end;

procedure TForm1.analyysClick(Sender: TObject);
var
  s : string;
begin
  tulemus.lines.clear;
  tulemus.lines.add (sqna.text);
  s := sqna.text;
  analyysi (s);
  tulemus.lines.add (s);
  sqna.setfocus;
  sqna.selectall;
end;

procedure TForm1.sqnaKeyPress(Sender: TObject; var Key: Char);
begin
  if failist then exit;
// enter ja ^a on anals
  if key = chr($0d) then analyysclick (sender);
  if key = chr($01) then analyysclick (sender);
// ^t on tbituvastus
  if key = chr($14) then tuvastatyypclick (sender);
// ^s on sntees
  if key = chr($13) then paradigmaclick (sender);
// esc on t lpetamine
  if key = chr($1b) then form1.close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if failist then
  begin
    if application.messagebox (
      'Faili ttlus on parasjagu pooleli. Kas lpetan sellest hoolimata?',
      'Anals',
      mb_YesNo + mb_defbutton1) = idYes
    then failist := false
    else exit;
  end;
  application.terminate;
end;

procedure TForm1.Lpeta1Click(Sender: TObject);
begin
  if failist then failist := false else form1.close;
end;

procedure TForm1.Ava1Click(Sender: TObject);
var
  fn : string;
  fs, xs, x_vorme, x_pikkus : longint;
  x_aeg, x_t : tdatetime;
  Hour, Min, Sec, MSec: Word;
  tmpf : file of char;
  s, sqna : string;
  i : integer;
begin
  if opendialog1.execute then
  begin
    tulemus.lines.clear;
    failist := true;
    fn := opendialog1.filename;
    assignfile (tmpf, fn); reset (tmpf);
    fs := filesize (tmpf);
    closefile (tmpf);
    assignfile (inf, fn); reset (inf);
    fn := changefileext (fn, '.out');
    tulemus.lines.add ('Vljundi leiate failist ' + fn);
    assignfile (outf, fn); rewrite (outf);
    xs := 0;
    x_vorme := 0; x_pikkus := 0; x_aeg := 0;

    while failist and not eof (inf) do
    begin
      readln (inf, s);
      xs := xs + length(s) + 2;
      gauge1.progress := trunc(xs/fs*100);
      repeat
        i := pos (' ', s);
        if i = 0 then i := length (s)+1;
        sqna := copy (s, 1, i-1);
        delete (s, 1, i);
        if sqna <> '' then
        begin
          if failist and not fsmode then writeln (outf, '#:) ');
          if failist then writeln (outf, sqna);
          inc (x_vorme);
          x_pikkus := x_pikkus + length (sqna);

          x_t := time;
          analyysi(sqna);
          x_aeg := x_aeg + time - x_t;

          if failist then
          begin
            writeln (outf, sqna);
            if not fsmode then writeln (outf);
          end;
          application.processmessages;
        end;
      until s = '';
    end;
    gauge1.progress := 0;
    closefile (inf);
    closefile (outf);
    failist := false;

    DecodeTime(x_aeg, Hour, Min, Sec, MSec);
    fs := sec + min*60 + hour*3600;
    if (x_vorme > 0) and (fs > 0) then
    begin
      tulemus.lines.add ('');
      tulemus.lines.add
        ('Analsitud ' + inttostr(x_vorme) + ' snavormi keskmise ' +
         'pikkusega ' + inttostr(round(x_pikkus/x_vorme)) + ' thte snavormis.');
      tulemus.lines.add
         ('Aega kulus ' + formatdatetime('hh:mm:ss', x_aeg) + ' (' +
         inttostr (round (x_vorme/fs)) + ' snavormi sekundis).');
    end;
  end;
end;

procedure TForm1.koostuletusegaClick(Sender: TObject);
begin
  sea_tuletusega (koostuletusega.checked);
end;

procedure TForm1.koossqnastikugaClick(Sender: TObject);
begin
  sea_sqnastikuga (koossqnastikuga.checked);
end;

procedure TForm1.koosliitsqnagaClick(Sender: TObject);
begin
  sea_liitsqna (koosliitsqnaga.checked);
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
// nagu siit nha, on hetkel defineeritud neli viisi vormikoodi
// esitamiseks ja parameetriks saab olla arv 0, 1, 2 vi 3
  sea_vxljundvorm (radiogroup1.itemindex);
  fsmode := (radiogroup1.itemindex = 3);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  fn, s, sqna : string;
  pluss : boolean;
  i : integer;
begin
  sea_sqnastikuga (koossqnastikuga.checked);
  sea_tuletusega (koostuletusega.checked);
  sea_liitsqna (koosliitsqnaga.checked);
  sea_vxljundvorm (radiogroup1.itemindex);
  fsmode := (radiogroup1.itemindex = 3);

  if paramcount > 0 then
  begin
    fn := '';
    for i := 1 to paramcount do
    begin
      s := paramstr(i);
      if (s[1] in ['/', '-']) and (length(s) > 1) then
      begin
        pluss := (length(s) = 2) or (s[3] = '+');
        case s[2] of
          'v', 'V' : if (length(s) > 2) and (s[3] in ['0'..'3']) then
                     begin
                       sea_vxljundvorm (strtoint(s[3]));
                       fsmode := (s[3] = '3');
                     end;
          't', 'T' : sea_tuletusega (pluss);
          's', 'S' : sea_sqnastikuga (pluss);
          'l', 'L' : sea_liitsqna (pluss);
          else begin end;
        end;
      end else fn := paramstr(i);
    end;

    failist := true;
    assignfile (inf, fn); reset (inf);
    fn := changefileext (fn, '.out');
    assignfile (outf, fn); rewrite (outf);

    while failist and not eof (inf) do
    begin
      readln (inf, s);
      repeat
        i := pos (' ', s);
        if i = 0 then i := length (s)+1;
        sqna := copy (s, 1, i-1);
        delete (s, 1, i);
        if sqna <> '' then
        begin
          if failist and not fsmode then writeln (outf, '#:) ');
          if failist then writeln (outf, sqna);
          analyysi(sqna);
          if failist then
          begin
            writeln (outf, sqna); writeln (outf);
          end;
          application.processmessages;
        end;
      until s = '';
    end;
    closefile (inf);
    closefile (outf);
    failist := false;
  end;
end;

procedure TForm1.tuvastatyypClick(Sender: TObject);
var
  p : array [0..4096] of char;
begin
// siin oleks mistlik sodi vlja puhastada.
  if sqna.text = '' then exit;
  tulemus.lines.clear;
  tulemus.lines.add (sqna.text);
  strlcopy (p, pchar(sqna.text), sizeof(p)-1);
  tyybituvastus (p, sizeof(p)-1);
  tulemus.lines.add (p);
  sqna.setfocus;
  sqna.selectall;
end;

procedure TForm1.paradigmaClick(Sender: TObject);
var
  formsBuffer : array[0..299] of SynthFormSet;
  synteesitudvorme, i, j, x_tyybinumber, x_variandinumber : integer;
  lemma : array[0..29] of char;
  itemStr, x_sqnaliik : String;
begin
// siin oleks mistlik sodi vlja puhastada.
  if sqna.text = '' then exit;
  tulemus.clear;
  tulemus.lines.add (sqna.text);

  x_tyybinumber := 0;
  x_variandinumber := 0;
  x_sqnaliik := '';

  StrPCopy (lemma, sqna.text);
// snteesil on jrjestus veidi teine
  j := (radiogroup1.itemindex + 2) mod 3;

  synteesitudvorme := SynthesizeForms (lemma, 0, j, formsBuffer, 300);
  if synteesitudvorme > 300 then synteesitudvorme := 300;

  tulemus.lines.beginupdate;
  if synteesitudvorme = 0 then
  begin
    tulemus.lines.add ('Sellist lemmat reeglid ei lubanud!');
  end
  else
  for i := 0 to synteesitudvorme - 1 do
  begin
    if (formsBuffer[i].tyybinumber <> x_tyybinumber) or
       (string (formsBuffer[i].sqnaliik) <> x_sqnaliik) or
       (formsBuffer[i].variandinumber <> x_variandinumber) then
    begin
      tulemus.lines.add ('');
      tulemus.lines.add ('*** ' + 'muuttp / declination type -- '
        + inttostr (formsBuffer[i].tyybinumber));
      tulemus.lines.add ('*** ' + 'snaliik / part of speech -- '
        + string (formsBuffer[i].sqnaliik));
      tulemus.lines.add ('*** ' + 'variant '
        + inttostr (formsBuffer[i].variandinumber));
      x_tyybinumber := formsBuffer[i].tyybinumber;
      x_sqnaliik := formsBuffer[i].sqnaliik;
      x_variandinumber := formsBuffer[i].variandinumber;
    end;

    itemStr := formsBuffer[i].vormikood + chr(9);

    for j := 0 to formsBuffer[i].paralleelvorme - 1 do
    begin
      if j > 0 then itemStr := itemStr + ' ~ ';
      itemStr := itemStr + formsBuffer[i].vormid[j].vorm +
                 ' (' + inttostr (formsBuffer[i].vormid[j].stemLength) + ')';
    end;
    tulemus.Lines.Add(itemStr);
  end;
  tulemus.lines.endupdate;
  sqna.setfocus;
  sqna.selectall;
end;

end.
