#!/usr/bin/perl -w

use utf8;
use Storable;

my $cgimode = (scalar(@ARGV) and ($ARGV[0] =~ /^\/tmp\// ? 1 : 0));

my $dbg = 0;		# väljasta móttekäik
my $errs = 0;		# väljasta ainult analüüsita jäänud jupskid
my $esi = 0;		# lópetame kohe esimese leiuga
my $tekst = '';		# failist voi cgi-lt

my $fail_kasutajatekst = '';
my $fail_formtab = 'formtab.pmf';
my $fail_formtablisa = 'dertab.pmf';
my $fail_tyvebaas = 'tyvebaas.pmf';
my $fail_liitsonajupid = 'liitsonajupid.pmf';
my $fail_erandid = 'vormierandid1.pmf';
my $fail_vormierandid = 'vormierandid2.pmf';

binmode (STDIN, ":utf8");
binmode (STDOUT, ":utf8") unless $cgimode;

my @formtab = ();
my %tyvebaas = ();
my %lsjupid = ();
my %erandid = ();
my %muutumatud = ();	# selle taidame TB lugemise kaigus

my $tulemusi = 0;
my $stat_sonesid = 0;
my $stat_tulemuseta = 0;
my $stat_variante = 0;
my $stat_algusaeg;


my ($fn, $dfn);

sub varske {
    my $fn = shift;
    my $dfn = shift;
    $dfn = $fn . '.dmp' unless $dfn;
    return ( (-e $fn) and (-e $dfn) and ((stat($fn))[9] < (stat($dfn))[9]) );
}

$fn = $fail_liitsonajupid;
$dfn = $fn . '.dmp';
if ( varske ($fn) ) {
    %lsjupid = %{ retrieve ($dfn) };
}
else {
    loesisse_liitsonajupid($fn);
    store \%lsjupid, $dfn;
}

$fn = $fail_formtab;
$dfn = $fn . '.dmp';
if ( varske($fail_formtab) and varske($fail_formtablisa, $dfn) ) {
    @formtab = @{ retrieve ($dfn) };
}
else {
    loesisse_formtab($fail_formtab);
    loesisse_formtab($fail_formtablisa);
    store \@formtab, $dfn;
}

$fn = $fail_erandid;
$dfn = $fn . '.dmp';
if ( varske($fail_erandid) and varske($fail_vormierandid, $dfn) ) {
    %erandid = %{ retrieve ($dfn) };
}
else {
    loesisse_erandid($fn);
    loesisse_vormierandid($fn);
    store \%erandid, $dfn;
}

$fn = $fail_tyvebaas;
$dfn = $fn . '.dmp';
if ( varske($fn) ) {
    %tyvebaas = %{ retrieve ($dfn) };
    %muutumatud = %{ retrieve ('muutumatud.pfm.dmp') };
}
else {
    loesisse_tyvebaas($fn);
    store \%tyvebaas, $dfn;
    store \%muutumatud, 'muutumatud.pfm.dmp';
}

print "./morf.pl [failinimi] [failinimi] ...\n" unless $cgimode;
print "analüüsi: .silu -- lülitab silumise sisse/välja\n" unless $cgimode;
print "analüüsi: .esi[mene] -- lópeta koheselt esimese sobiva variandi leidmisel\n" unless $cgimode;
print "analüüsi: .vead -- väljastab ainult analüüsita stringid\n" unless $cgimode;
print "analüüsi: .fail failinimi -- analüüsib faili sisu\n" unless $cgimode;
print "analüüsi: -- tühi rida vói ^C väljub\n" unless $cgimode;
print "Meeldivat alalüüsimist!\n" unless $cgimode;

###############

$stat_algusaeg = time;

# kóik käsureal olevad failinimed käiatakse läbi:
foreach my $a (0..$#ARGV) {
    $dbg = not $dbg if $ARGV[$a] eq '.silu';
    $errs = not $errs if $ARGV[$a] eq '.vead';
    $esi = not $esi if ($ARGV[$a] eq '.esi') or ($ARGV[$a] eq '.esimene');
}
foreach my $a (0..$#ARGV) { 
    analyysi_fail ($ARGV[$a]) unless $ARGV[$a] =~ /^\./;
    exit if $cgimode;
}
print "\n";


$| = 1;

my $kasutajasisend = '';
do {
    print "Valmis analyysima: ";
    $kasutajasisend = <STDIN>;
    chomp ($kasutajasisend);
    if ($kasutajasisend =~ /^\.silu/i) { $dbg = not $dbg; }
    elsif ($kasutajasisend =~ /^\.vead/i) { $errs = not $errs; }
    elsif ($kasutajasisend =~ /^\.esi/i) { $esi = not $esi; }
    elsif ($kasutajasisend =~ /^\.fail (.+)/i) { analyysi_fail ($1); }
    else {
	analyysi( $kasutajasisend );
    }
} until ($kasutajasisend eq '');


my $svar = 0;
print "\n\nStatistika:\n";

$svar = time - $stat_algusaeg;
print "\taega kulus $svar sekundit, ";
$svar = ( $svar ? $stat_sonesid/$svar : 'lópmatus' );
print "$svar sónet sekundis\n";
print "\tsonesid analüüsiti $stat_sonesid\n";
print "\tvastuse sai neist ", $stat_sonesid-$stat_tulemuseta, ", lahenduseta jäi $stat_tulemuseta\n";

$svar = ( $stat_sonesid ? $stat_variante/$stat_sonesid : 'null' );
print "\tleitud sónedel oli keskmiselt $svar analüüsivarianti\n";


###############

sub asendataheklassid {
    my $tingimus = shift;
    if ($tingimus =~ /%[A-Z]/) {
	return asendataheklassid($`) . $& . asendataheklassid($');
    }

    $tingimus =~ s/W/[aeiouõäöüy]/go;
    $tingimus =~ s/E/[aeu]/go;
    $tingimus =~ s/I/[aei]/go;
    $tingimus =~ s/U/[iuü]/go;
    $tingimus =~ s/Y/[aiõ]/go;
    $tingimus =~ s/X/[eouäöü]/go;
    $tingimus =~ s/A/[aeiou]/go;
    $tingimus =~ s/O/[õäöü]/go;
    $tingimus =~ s/C/[bcdfghjklmnpqrsšzžtvwx]/go;
    $tingimus =~ s/Q/[kptfš]/go;
    $tingimus =~ s/G/[gbd]/go;
    $tingimus =~ s/K/[kpt]/go;
    $tingimus =~ s/Z/[gbdlmnrvshjzž]/go;
    $tingimus =~ s/H/[lmnrvshjzž]/go;
    $tingimus =~ s/V/[lmnrvwž]/go;
    $tingimus =~ s/M/[lmnrv]/go;
    $tingimus =~ s/L/[lmnr]/go;
    $tingimus =~ s/N/[lnr]/go;
    $tingimus =~ s/R/[nr]/go;
    $tingimus =~ s/J/[lrvj]/go;
    $tingimus =~ s/T/[gbdkptlmnrvshj]/go;
    $tingimus =~ s/B/[gbdjfšzž]/go;
    $tingimus =~ s/D/[ntd]/go;
    $tingimus =~ s/F/[fš]/go;
    $tingimus =~ s/S/[sh]/go;
    $tingimus =~ s/Ü/[ie]/go;
    $tingimus =~ s/Ä/[ns]/go;
    $tingimus =~ s/Õ/[mjntv]/go;
    $tingimus =~ s/Ö/[dtslkng]/go;
    $tingimus =~ s/P/[gbdkptfh]/go;

    return $tingimus;
}

sub slurpin {
    my ($fn, $href) = @_;
    my $dfn = $fn . '.dmp';
    if ( (-e $fn) and (-e $dfn) and ((stat($fn))[9] < (stat($dfn))[9]) ) {
	$href = retrieve ($dfn);
    }
}

sub spitout {
    my ($fn, $href) = @_;
    my $dfn = $fn . '.dmp';
    store $href, $dfn;
}



sub loesisse_liitsonajupid {
    my $misnimeline = shift;
    open (F, "<$misnimeline") or die "puudub $misnimeline!";
    binmode (F, ":utf8");
    while (<F>) {
	chomp;
	$lsjupid{ $_ } = 1;
    }
}

sub loesisse_erandid {
    my $misnimeline = shift;
    open (F, "<$misnimeline") or die "puudub $misnimeline!";
    binmode (F, ":utf8");
    while (<F>) {
	chomp;
	next unless /^([^ ]+) .*?\(([^ ]+) .*?>(.+)/;
	$erandid{ $1 } = ":$2 $3:";
    }
}

sub loesisse_vormierandid {
    my $misnimeline = shift;
    open (F, "<$misnimeline") or die "puudub $misnimeline!";
    binmode (F, ":utf8");
    while (<F>) {
	chomp;
	my ($tk, $lemma, $vorm, $vormikood, $muu) = split (/,/, $_);
	next unless $vorm;
	# vormid, mida me EI tohiks moodustada jätame hetkel tähelepanuta.
	# vóiks muidugi kontrollida, et enese nimetavat käänet pole olemas vói
	# hea mitmuse osastav peab olema häid, mitte aga heasid, aga keelama ei hakka.
	next if $vorm eq '#';
	$vorm =~ s/[\'\[\]]//g;
	$erandid{ $vorm } .= ":$vormikood $lemma:";
    }
}

# LOE SISSE FORM.TAB
# jagame tyved eraldi kirjeteks ja kontrollime sealjuures korduste vältimiseks, kas selline juba oli

sub loesisse_formtab {
    my $misnimeline = shift;
    open (F, "<$misnimeline") or die "puudub $misnimeline!";
    binmode (F, ":utf8");
    my %vakantsid = ();
    my %jubaoli = ();
    my @fttemp = ();

    while (<F>) {
	chomp;
	next unless $_;		# tyhi rida
	next if /^[;#]/;	# kommentaar, alguses # voi ;
	next if /^\/\//;	# kommentaar, alguses //
	push @fttemp, $_;
	my ($formatiiv, $vormikood, $tingimus, $tyved) = split (/,/, $_, 4);
	# unless on vajalik ,-----0G mitmetähenduslikkuse tóttu
	$vakantsid{ $formatiiv . ',' . $vormikood } = $tyved unless $vakantsid{ $formatiiv . ',' . $vormikood };
    }

    foreach (@fttemp) {
	my ($formatiiv, $vormikood, $tingimus, $tyved) = split (/,/, $_, 4);
	$tingimus = asendataheklassid ($tingimus);
	if ($tyved =~ /^=/) { $tyved = $vakantsid{ $' }; }
# if ($formatiiv eq 'd') { print "$vormikood $tyved\n"; sleep (5); }
	foreach my $t (split (/,/, $tyved)) {
	    my $yksiktyvi = "$formatiiv,$vormikood,$tingimus,$t";
	    next if $jubaoli{$yksiktyvi};	# tuletusega osas on palju topelt -- 9~11 paralleelid, -(a|e|u) jms
	    $jubaoli{$yksiktyvi} = 1;
	    push @formtab, $yksiktyvi;
	    print "$yksiktyvi\n" if $dbg;
	}
    }
}

# LOE SISSE _TB.TXT

sub lisatuletustyved {
    my ($tyvi, $tyyp, $tyvekood, $lemma, $sliik) = @_;

    if ($tyyp eq '27') {
	if ($tyvekood eq 'a0') {
	    if ($tyvi =~ /tse$/) { $tyvekood = ':27d0tsus'; $tyvi = $`; goto UUSTT; }
	    if ($tyvi =~ /le$/) { $tyvekood = ':27d0lus'; $tyvi = $`; goto UUSTT; }
	    if ($tyvi =~ /ta$/) { $tyvekood = ':27d0tus'; $tyvi = $`; goto UUSTT; }
	    if ($tyvi =~ /da$/) { $tyvekood = ':27d0dus'; $tyvi = $`; goto UUSTT; }
	}
    }
    if ($tyyp eq '12') {
	if ($tyvekood eq 'b0') {
	    if ($tyvi =~ /lase$/) { $tyvekood = ':27d0lus'; $tyvi = $`; goto UUSTT; }
	}
    }
    if ($tyyp eq '10') {
	if ($tyvekood eq 'b0') {
	    if ($sliik eq 'A') {
		if ($tyvi =~ /stikuse$/) { $tyvekood = ':10d0stikkus'; $tyvi = $`; goto UUSTT; }
	    }
	}
    }
    if ($tyyp eq '02') {
	if ($tyvekood eq 'b0') {
	    if ($sliik eq 'A') {
		if ($tyvi =~ /bli$/) { $tyvekood = ':02d0blus'; $tyvi = $`; goto UUSTT; }
		if ($tyvi =~ /(a|e|u)$/) { $tyvekood = ':02d0us'; $tyvi = $`; goto UUSTT; }
	    }
	}
    }
    if ($tyyp eq '25') {
	if ($tyvekood eq 'bt') {
	    if ($sliik eq 'A') {
		if ($tyvi =~ /u$/) { $tyvekood = ':25d0us'; $tyvi = $`; goto UUSTT; }
	    }
	}
    }
    if ($tyyp eq '07') {
	if ($tyvekood eq 'bt') {
	    if ($sliik eq 'A') {
		if ($tyvi =~ /u$/) { $tyvekood = ':07d0us'; $tyvi = $`; goto UUSTT; }
	    }
	}
    }
    if ($tyyp eq '03') {
	if ($tyvekood eq 'bt') {
	    if ($sliik eq 'A') {
		if ($tyvi =~ /u$/) { $tyvekood = ':03d0us'; $tyvi = $`; goto UUSTT; }
	    }
	}
    }
    if ($tyyp eq '01') {
	if ($tyvekood eq 'a0') {
	    if ($sliik eq 'A') {
		if ($tyvi =~ /e$/) { $tyvekood = ':01d0us'; $tyvi = $`; goto UUSTT; }
	    }
	}
    }

    return;

UUSTT:
#    $tyvi = $`;
    $tyvekood .= "#$lemma:";
    $tyvebaas{$tyvi} .= $tyvekood;
    print "$tyvi == $tyvekood\n" if $dbg;
}

sub loesisse_tyvebaas {
	my $misnimeline = shift;
	return if keys (%tyvebaas);
	open (F, "<$misnimeline") or die "puudub $misnimeline!";
	binmode (F, ":utf8");
	%tyvebaas = ();
	while (<F>) {
		chomp;
		next unless $_;		# tyhi rida
		next if /^[;#]/;	# kommentaar, alguses # voi ;
		next if /^\/\//;	# kommentaar, alguses //

		# tyvebaasi rida
		my $tyved = '';		# (muutumatud on ilma eraldajata ja tyvedeta)
		next unless /^(.)([^ ]+) ([0-9][0-9])_([A-Y]+)/;
		my $lemma = $2;
		my $tyyp = $3;
		my $sliik = $4;
		$tyved = $';
		$tyved = $' if $tyved =~ /^\s+\|?\s+/;

		if ($tyved eq '') {
		    $lemma =~ s/[\']//g;
		    $muutumatud{$lemma} .= ":${tyyp}_${sliik}:";
		}

		foreach (split (/,/, $tyved)) {
			next unless /([a-y0]+): /;
			my $tyvi = $';
			my $tyvekood = $1;
			$tyvi =~ s/[\']//g;

			$tyvebaas{$tyvi} .= ":$tyyp$tyvekood#$lemma#$sliik:";
			# print "$tyvi = $tyyp$tyvekood\n" if $tyvi =~ /aa/;
			#prots lisab %tyvebaasile kavatsema taha d0tsus: kava
			lisatuletustyved ($tyvi, $tyyp, $tyvekood, $lemma, $sliik);
		}
	}
}

# ANALYYSI

sub testitingimust {
    my ($algus, $tingimus) = @_;
    my $sonaliik = '';
    my $kustuta = 0;
    if ($tingimus =~ /%([A-Z])/) { $tingimus = $`; $sonaliik = $1; }
    if ($tingimus =~ /^\-/) { $tingimus = $'; $kustuta = 1; }
    if ($algus =~ /$tingimus$/) {
	print "algus: $algus, tingimus: $tingimus\n";
	$algus = $` if $kustuta;
	return $algus;
    } else { 
	return '';
    }
}

sub jaga_liitsonajuppideks {
    my $suurjupp = shift;
    return $suurjupp if $lsjupid{$suurjupp};
    return '' unless $suurjupp;

    my $i = 2;
    while ( $i <= length($suurjupp)-2 ) {
	my $sonaalgus = substr $suurjupp, 0, $i;
	my $sonalopp = substr $suurjupp, $i;
	$i++;
	next unless $lsjupid{$sonaalgus};
        $sonalopp = jaga_liitsonajuppideks ($sonalopp);
        next if $sonalopp eq '?';
	return "$sonaalgus+$sonalopp";
    }
    return '?';
}

sub puhastasona {
    my $mustsona = shift;
    $mustsona =~ s/[\.,!\-]//g;
    $mustsona =~ y/óÓ/\x{f5}\x{d5}/;
    return $mustsona;
}

sub analyysi_fail {
    my $fn = shift;
    if (-e $fn) {
	open (F, "<$fn");
	binmode (F, "utf8");
	while (<F>) { analyysi ($_); }
	close (F);
    }
    else { print "Ei leia faili $fn!\n"; }
}

sub analyysi {
    my $miski = shift;
    return unless $miski;
    foreach my $s (split(/\s+/, $miski)) {
	next unless $s;
	$s = puhastasona ($s);
	$s = lc($s);
	next unless $s;

	print "\n# $s\n";
	$tulemusi = 0;
	analyysi_liitsona ($s);
	print "???\t$s\n" unless $tulemusi;
	$stat_sonesid++;
	if ($tulemusi) { $stat_variante += $tulemusi; } else { $stat_tulemuseta++; }
    }
}

sub analyysi_liitsona {
    my $sona = shift;
    my $i = 0;
    while ( $i <= length($sona)-2 ) {
	my $sonaalgus = substr $sona, 0, $i;
	print "liitsonaalus: $sonaalgus -> " if $dbg;
	my $sonalopp = substr $sona, $i;
	$i++;
        $sonaalgus = jaga_liitsonajuppideks ($sonaalgus);
	print "$sonaalgus\n" if $dbg;
        next if $sonaalgus eq '?';
        analyysi_lihtsona ($sonalopp, $sonaalgus);
	return if ($tulemusi and $esi);
    }
}

sub analyysi_lihtsona {
    my $sona = shift;
    my $liitsonaalgus = shift;
    $liitsonaalgus .= '+' if $liitsonaalgus;
    print "Lihtsona: $liitsonaalgus $sona\n" if $dbg;

    my $tyvebaasityvekoodid = '';

    if ( $muutumatud{$sona} ) {
	$tyvebaasityvekoodid = $muutumatud{$sona};
	while ($tyvebaasityvekoodid =~ /:([^:]+):/) {
	    $tyvebaasityvekoodid = $` . ':' . $';
	    my $tbinf = $1;
	    print "-------- $liitsonaalgus$sona $tbinf\n" unless $errs;
	    $tulemusi++;
	    return if $esi;
	}
    }

    if ( $erandid{$sona} ) {
	$tyvebaasityvekoodid = $erandid{$sona};
	while ($tyvebaasityvekoodid =~ /:([^:]+):/) {
	    $tyvebaasityvekoodid = $` . ':' . $';
	    my $tbinf = $1;
	    print "$tbinf\n" unless $errs;
	    $tulemusi++;
	    return if $esi;
	}
    }

# parem siiski lühemalt lópult pikema poole
#    my $i = 2;
#    while ( $i <= length($sona) ) {
    my $i = length($sona);
    while ( $i >= 2 ) {
	my $sonaalgus = substr $sona, 0, $i;
	my $sonalopp = substr $sona, $i;
	$i--;

	print "\nüritan jagada $sonaalgus + $sonalopp\n" if $dbg;
	my $tyvebaasityvekoodid = $tyvebaas{$sonaalgus};
	# jah, vahemalt yks selline tyvi on tyvebaasis olemas
	next unless $tyvebaasityvekoodid;
	print "\t... $sonaalgus on tüvebaasis: $tyvebaasityvekoodid\n" if $dbg;

	#jagame mugavamalt massiiviks
        my @tbkoodid = ();
        while ($tyvebaasityvekoodid =~ /:([^:]+):/) {
	    $tyvebaasityvekoodid = $` . ':' . $';
	    push @tbkoodid, $1;
	}

	# NB eeldab juba, et formtabis on tüvekoodid eraldi ridadeks jaotatud
	foreach (@formtab) {
	    my ($formatiiv, $vormikood, $tingimus, $fttk) = split (/,/, $_, 4);
	    next unless $formatiiv eq $sonalopp;
#	    print "\t... $sonalopp on formatiiv: $_\n" if $dbg;

	    foreach my $tbinf (@tbkoodid) {
#		print "\t\t$tbinf\n" if $dbg;
		my ($tbtk, $lemma, $sliik) = split (/#/, $tbinf);
#		print "\t\tkas tüvebaasi $tbtk on sama mis formtabi $fttk?\n" if $dbg;
		next unless $tbtk eq $fttk;
		# tk on yhine nii tyvel kui lopul
		print "$vormikood $liitsonaalgus$lemma + $formatiiv\n" unless $errs;
		$tulemusi++;
		return if $esi;
	    }
	}
    }
}
