unit demo_unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, Gauges;

type
  TForm1 = class(TForm)
    sqna: TEdit;
    silbita: TButton;
    Label1: TLabel;
    Memo1: TMemo;
    procedure sqnaKeyPress(Sender: TObject; var Key: Char);
    procedure silbitaClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type
  PSyllabificationResult = ^SyllabificationResult;
  SyllabificationResult =
  record
    word: array[0..127] of char;        // silbitatud sna
    numSyllables: integer;              // leitud silpide arv
    next: PSyllabificationResult;       // viit jrgmisele kirjele
    lastPlace: integer;                 // thtede arv snas
  end;

function syllabify (word : PChar) : PSyllabificationResult;
  stdcall; external 'syllabif.dll';
procedure deleteResults (first : PSyllabificationResult);
  stdcall; external 'syllabif.dll';

// ------------------------------------------------------------------

procedure silbitus (s : string);
const
// pole oluline, kui pikk on sisend, peaasi, et ra mahub
  sonapikkus = 127;
var
  si : array [0..sonapikkus] of char;
  so : string;
  psyrr, psyrr_res : Psyllabificationresult;
begin
  if s = '' then exit;
  strlcopy (si, pchar(s), sonapikkus);
  psyrr_res := syllabify (si);

// psyrr_res on vaja silitada parameetriks tulemuste
// kustutajale (deleteresults)
  psyrr := psyrr_res;

  form1.memo1.clear;
// repeat..until ei saa kasutada, sest juba esimene tagastatud viit
// vib olla nil, seda sisendiga, mis ei sisalda thti.
  while psyrr <> nil do
  begin
    so := psyrr^.word;
    so := so + ' -- ' + inttostr(psyrr^.numsyllables) + ' silp';
    if psyrr^.numsyllables <> 1 then so := so + 'i';
    so := so + ', ' + inttostr(psyrr^.lastplace) + ' tht';
    if psyrr^.lastplace <> 1 then so := so + 'e';
    form1.memo1.lines.add (so);
    psyrr := psyrr^.next;
  end;

  deleteresults (psyrr_res);
  form1.sqna.setfocus;
  form1.sqna.selectall;
end;

procedure TForm1.sqnaKeyPress(Sender: TObject; var Key: Char);
begin
  if key = chr($0d) then silbitus (sqna.text);
// esc on t lpetamine
  if key = chr($1b) then form1.close;
end;

procedure TForm1.silbitaClick(Sender: TObject);
begin
  silbitus (sqna.text);
end;

end.
