#ifndef GRAMMAR_HPP
#define GRAMMAR_HPP

#include <deque>
#include "strndef.hpp"

#include <stdio.h>

#include "derivres.hpp"

const int kInitialNumberOfRules=20;
const int kDeltaOfRules=20;

#ifdef __BORLANDC__
typedef std::deque<std_string> StringArray;
#else
typedef deque<std_string> StringArray;
#endif

struct RulePrelim
{
   char left[8];
   char right[8];
   char leftCtx[8];
   char rightCtx[8];
};


class Rule
{
public:
   Rule(std_string upper, std_string lower, std_string leftContext, std_string rightContext);
   Rule();
   Rule(const Rule &rule);
   ~Rule();
   Rule& operator=(const Rule &rule);
   int operator==(const Rule &rule);
   int isMatching(const std_string &inString, int posToCompare, int *ppos);
   std_string transform(const std_string &inString, int pos);
   int lengthOfComparablePart();
   std_string asText();
private:
   std_string fUpper;
   std_string fLower;
   std_string fLeftContext;
   std_string fRightContext;
   std_string fWholePattern;
   int fCompLength;
   int fLeftLength;
};

#ifdef __BORLANDC__
typedef std::deque<Rule> RuleArray;
#else
typedef deque<Rule> RuleArray;
#endif

const unsigned long kAllocUnit=65536;
const unsigned long kReadableUnit=8192;

struct ExceptionData
{
  char nr;
  char lemma[30];
  char form[30];
  char excCode[6];
  char ruleToo;

  void set(char n, char *l, char *f, char *c, char *r)
  {
    nr=n;
    strcpy(lemma, l);
    strcpy(form, f);
    strcpy(excCode, c);
    ruleToo=r? *r: 0;
  }

  char *elem(int k) { return k? form: lemma; }
};


class ExceptionRegistry
{
public:
   enum IndexMode {kLeft=0, kRight=1, kBoth=2};
   ExceptionRegistry(const char *exceptFileName);
   ~ExceptionRegistry();
   ExceptionRegistry& setIndexMode(IndexMode iMode);
   ExceptionRegistry& createIndices();
   int findExceptions(ResultCollection *pResult, DerivationResult *pInput,
                      int start, int typeId, std_string grammarName, int withAppostr,
                      int *pHasRuleBasedAlso, std_string &detectedToken);
   StringArray* findPdgmExceptions(std_string sInput, int start, int typeId,
                                   std_string grammarName, int withAppostr,
                                   int *pHasRuleBasedAlso);
private:
   unsigned long* findAddress(int start, int typeId, const std_string &form,
                              int withAppostr);
   int isIndexFileOutOfDate();
   void readIndicesFromFile();
   void saveIndicesToFile();
   std_string fExceptFileName;
   IndexMode fIndexMode;
   unsigned short *fpIndex[2][40];
   ExceptionData *fpData;
   unsigned short fTypeSizes[40];
   unsigned long fNrLines;
};

inline int flip(int x) { return x^1; }


class Grammar
{
public:
   Grammar(std_string grammarName);
   ~Grammar();
   int loadFromFile(const char * const fileName);
   void loadFromArray(RulePrelim *pStaticRules, int nrStaticRules);
   Grammar& addRule(const Rule &rule);
   void transform(ResultCollection *pResult, DerivationResult *pInput,
                  int withAppostr, const std_string &tokenFromExceptions, int *msg=0);
   Grammar& unload();
   Grammar& setExceptionRegistry(ExceptionRegistry *pExcRegistry, int baseIsLeft);
   int findExceptionalForms(ResultCollection *pResult, DerivationResult *pInput,
                            int typeId, int withAppostr,
                            int *pHasRuleBasedAlso, std_string &tokenFromExceptions);
   std_string name() const { return fName; }

   enum Masks { kDegree=0x0001, kPlus=0x0002, kZeroPos=0x0004, kOrigOutput=8 };

   void addFlags(Masks toAdd) { flags|=toAdd; }
   void removeFlags(Masks toRemove) { flags&=~toRemove; }

private:
   RuleArray fRulesWithAppostr;
   RuleArray fRulesWithoutAppostr;
   char  flags;
   ExceptionRegistry *fpExcRegistry;
   int fBaseIsLeft;
   std_string fName;
};


unsigned int significantPosition(const std_string &aWord);

inline std_string& removeAppostrophes(std_string &buf)
{
   int pos=buf.length();

   while(pos!=std_string::npos && pos>0)
   {
      pos--;
      pos=buf.rfind("'", pos);

      if(pos!=std_string::npos)
         buf.remove(pos, 1);
   }

   return buf;
}


#endif //GRAMMAR_HPP