#include "tdexc.hpp"

#ifdef LINUX_PORT
#include <sys/stat.h>
#else
#include <sys\stat.h>
#endif

#include <set>
#include <algorithm>

#include <openfile.h>
#include <appostr.hpp>

#define DBGAAA1(s, x) { FILE *f=fopen("dbg.aaa", "a"); \
                       fprintf(f, s, x); fclose(f); }

#define DBGAAA2(s, x, y) { FILE *f=fopen("dbg.aaa", "a"); \
                           fprintf(f, s, x, y); fclose(f); }

#define DBGAAA3(s, x, y, z) { FILE *f=fopen("dbg.aaa", "a"); \
                              fprintf(f, s, x, y, z); fclose(f); }

#ifdef __BORLANDC__
typedef std::set<std_string, std::less<std_string> > StringSet;
#else
typedef set<std_string, less<std_string> > StringSet;
#endif


IndeclExcRegistry::IndeclExcRegistry(const char *exceptFileName):
fExceptFileName(exceptFileName), fNrLines(0),
fpData(0)
{
}

IndeclExcRegistry::~IndeclExcRegistry()
{
  delete [] fpIndex;
  fpIndex=0;

  delete [] fpData;
  fpData=0;
}

inline int isSpecialChar(char c)
{
  if(c=='\'' || c=='`' || c=='.')
    return 1;
  else
    return 0;
}

void deSpecialise(char *s)
{
  int diff=0;
  do{
    if( isSpecialChar( *(s+diff) ) )
      diff++;
    *s=*(s+diff);
  }
  while(*s++);
}

struct WordComp
{
  WordComp(IndeclExcData *pData):fpData(pData) {}

  bool operator()(unsigned short i, unsigned short j) const
  {
    return strAppstrCmp(fpData[i].word, fpData[j].word)<0;
  }

  IndeclExcData *fpData;
};

struct WordSrchComp
{
  WordSrchComp(IndeclExcData *pData, const char *w):fpData(pData), word(w) {}

  bool operator()(unsigned short i, unsigned short j) const
  {
    const char *s1, *s2;
    if(i==0xFFFF){
      s1=word; s2=fpData[j].word;
    }
    else if(j==0xFFFF){
      s1=fpData[i].word; s2=word;
    }
    else{
      s1=fpData[i].word; s2=fpData[j].word;
    }

    return strAppstrCmp(s1, s2)<0;
  }

  const char *word;
  IndeclExcData *fpData;
};

IndeclExcRegistry& IndeclExcRegistry::createIndices()
{
  FILE *excFile=openAtLoc(fExceptFileName.c_str(), "r", false);
  if(!excFile)
    return *this;

  char buf[80];

  int allocated = 200;
  fpData=(IndeclExcData*)malloc(sizeof(IndeclExcData) * allocated);

  while(fgets(buf, 80, excFile)){
    char *w=strtok(buf, " \t\n");
    if(!w)
      continue;
    char *t=strtok(0, " \t\n");
    char *r=strtok(0, " \t\n");

    if(w && t){
      strcpy(fpData[fNrLines].word, w);
      strcpy(fpData[fNrLines].data, t);
      //deSpecialise(fpData[fNrLines].word);
      if(r)
        fpData[fNrLines].ruleToo=*r;

      fNrLines++;
      if(fNrLines==allocated){
        allocated*=2;
        fpData=(IndeclExcData*)realloc(fpData, sizeof(IndeclExcData) * allocated);
      }
    }
  }

  fclose(excFile);

  //final adjustment
  fpData=(IndeclExcData*)realloc(fpData, sizeof(IndeclExcData) * fNrLines);

  fpIndex=(unsigned short*)malloc(sizeof(unsigned short)*fNrLines);

  if(isIndexFileOutOfDate())
  {
    for(int i=0; i<fNrLines; i++){
      fpIndex[i]=i;
    }

#ifdef __BORLANDC__
    std::sort(&fpIndex[0], &fpIndex[fNrLines], WordComp(fpData));
#else
    sort(&fpIndex[0], &fpIndex[fNrLines], WordComp(fpData));
#endif

    saveIndicesToFile();
  }
  else
    readIndicesFromFile();

   return *this;
}

inline std_string replaceExtension(const std_string &original, const std_string &ext)
{
   std_string outstr(original);
   int pos=outstr.rfind(".");
   if(pos==std_string::npos)
      outstr+="."+ext;
   else
      outstr.replace(pos+1, outstr.length()-pos-1, ext);
   return outstr;
}

int IndeclExcRegistry::isIndexFileOutOfDate()
{
   std_string fileNameInd=replaceExtension(fExceptFileName, "ndx");
   struct stat statbufExc, statbufInd;
   stat(fExceptFileName.c_str(), &statbufExc);
   int ret=stat(fileNameInd.c_str(), &statbufInd);
   if(ret || statbufInd.st_mtime<statbufExc.st_mtime)
      return 1;
   else
      return 0;
}


void IndeclExcRegistry::readIndicesFromFile()
{
  std_string indexFileName=replaceExtension(fExceptFileName, "ndx");
  FILE *indexFile=openAtLoc(indexFileName.c_str(), "rb");
  if(indexFile){
    fread(fpIndex, sizeof(unsigned short), fNrLines, indexFile);
    fclose(indexFile);
  }
}

void IndeclExcRegistry::saveIndicesToFile()
{
  std_string indexFileName=replaceExtension(fExceptFileName, "ndx");
  FILE *indexFile=openAtLoc(indexFileName.c_str(), "wb");
  fwrite(fpIndex, sizeof(unsigned short), fNrLines, indexFile);
  fclose(indexFile);
}

int IndeclExcRegistry::findExceptions(char *results,
                                      const char *inputWord,
                                      int withAppostr,
                                      int *pHasRuleBasedAlso)
{

  int nrExceptions=0;
  *pHasRuleBasedAlso=0;

  unsigned short *pStart;
#ifdef __BORLANDC__
    pStart=std::lower_bound(fpIndex, fpIndex+fNrLines, 0xFFFF,
                            WordSrchComp(fpData, inputWord));
#else
    pStart=lower_bound(fpIndex, fpIndex+fNrLines , 0xFFFF,
                       WordSrchComp(fpData, inputWord));
#endif
  int different=0;
  while(pStart<fpIndex+fNrLines && !different){
    int cur=*pStart;
    if(withAppostr && strcmp(fpData[cur].word, inputWord) == 0 ||
       !withAppostr && strAppstrCmp(fpData[cur].word, inputWord) == 0){
      if(nrExceptions)
        strcat(results, "|");
      strcat(results, fpData[cur].data);
      if(fpData[cur].ruleToo)
        *pHasRuleBasedAlso=1;
      nrExceptions++;
    }
    else if(strAppstrCmp(fpData[cur].word, inputWord) != 0)
      different=1;
    pStart++;
  }

  return nrExceptions;
}


