#include <stdio.h>
#include <string.h>

#include "patmatch_exp.h"
#include "typedet_exp.h"

int main(int argc, char *argv[])
{
#ifdef LINUX_PORT
  initTypeDetector();
#endif
  FILE *input;

  if(argc>1){
    input=fopen(argv[1], "r");
    if(!input){
      fprintf(stderr, "Could not open %s\n", argv[1]);
      return 1;
    }
  }
  else {
    fprintf(stderr, "USAGE: %s input-file\n", argv[0]);
    return 2;
  }

  char inputString[100], outputString[100];
  while(fgets(inputString, 100, input)){
    char *realInput=strtok(inputString, " \t\n");
    if(realInput){
      if(isEstonianWord(realInput)){
        FindTypes(realInput, outputString, 99, 0);
        printf("%s %s\n", realInput, outputString);
      }
      else
        printf("VIGA! '%s' sisaldab valesid ta\"rke!\n", realInput);
    }
  }

  fclose(input);
#ifdef LINUX_PORT
  uninitTypeDetector();
#endif

  return 0;
}



