library typedet;

uses
  SysUtils, classes, windows;

const
  tderandid_fail = 'tyybituvastus.era';
type
  Terandirida = class (Tobject)
    puhastamata : string;
    tyypliik : string;
    jxtka : boolean;
  end;
var
  SaveExit: Pointer;
  est_morpho_data : string;
  tderandid : Tstringlist;

function ago_FindTypes (
  inputString  : PChar;
  outputString : PChar;
  outputLength : integer;
  durationmark : integer) : integer;
  stdcall; external 'ago_typedet.dll' name 'FindTypes';

function ago_FindStemTypes (
  inputString  : PChar;
  outputString : PChar;
  outputLength : integer;
  durationmark : integer) : integer;
  stdcall; external 'ago_typedet.dll' name 'FindStemTypes';

{$R *.RES}

function puhas (s : string) : string;
var
  i : integer;
begin
  result := '';
  for i := 1 to length(s) do
    if not (s[i] in ['''','`']) then result := result + s[i];
end;

function minu_FindTypes (
  inputString  : PChar;
  outputString : PChar;
  outputLength : integer;
  durationmark : integer) : integer; stdcall export;
var
  s, si, so : string;
  i : integer;
  er_puhastamata : string;
  er_tyypliik : string;
  er_jxtka : boolean;
begin
  so := '';
  si := inputstring;
  s := puhas (si);
  i := tderandid.indexof (s);
  if (i >= 0) then
  while (i < tderandid.count) and (tderandid[i] = s) do
  begin
    with terandirida(tderandid.objects[i]) do
    begin
      er_puhastamata := puhastamata;
      er_tyypliik := tyypliik;
      er_jxtka := jxtka;
    end;
    if (durationmark = 0) or (si = er_puhastamata) then
    begin
      if so <> '' then so := so + '|';
      so := so + er_tyypliik;
    end;
    if er_jxtka then
    begin
      ago_FindTypes (inputstring, outputstring, outputlength, durationmark);
      so := outputstring + '|' + so;
    end;
    inc (i);
  end
  else
  begin
    ago_FindTypes (inputstring, outputstring, outputlength, durationmark);
    so := outputstring;
  end;

  strlcopy (outputstring, pchar(so), outputlength);
  result := 1;
end;
exports minu_FindTypes name 'FindTypes';

function minu_FindStemTypes (
  inputString  : PChar;
  outputString : PChar;
  outputLength : integer;
  durationmark : integer) : integer; stdcall export;
begin
  result := ago_FindStemTypes (inputstring, outputstring, outputlength, durationmark);
end;
exports minu_FindStemTypes name 'FindStemTypes';

{
procedure initTypeDetector; stdcall export;
begin
end;
exports initTypeDetector;

procedure uninitTypeDetector; stdcall export;
begin
end;
exports uninitTypeDetector;
}

function get_morpho_dir : string;
const
  buflen = 512;
var
  mdir : array [0..buflen] of char;
begin
  if GetEnvironmentVariable ('EST_MORPHO_DATA', mdir, buflen) > 0
    then result := mdir else result := '';
  if result <> '' then
  begin
    result := result + '\';
    result := stringreplace (result, '\\', '\', [rfreplaceall]);
  end;
end;

procedure loe_tderandid;
var
  s, puhass : string;
  i, j : integer;
  er : Terandirida;
begin
  tderandid := Tstringlist.create;
  tderandid.sorted := false;
  tderandid.duplicates := dupaccept;

  s := est_morpho_data + tderandid_fail;
  if not fileexists (s) then
  begin
    s := tderandid_fail;
    if not fileexists (s) then exit;
  end;

  tderandid.loadfromfile (s);
  for i := tderandid.count - 1 downto 0 do
  begin
    s := trim (tderandid[i]);
    if not ((s = '') or (s[1] in ['#', ';'])) then
    begin
      er := Terandirida.create;
      j := pos(' ', s);
      puhass := copy (s, 1, j-1);
      er.puhastamata := puhass;
      delete (s, 1, j);
      j := pos(' ', s);
      if j = 0 then j := length(s) + 1;
      er.tyypliik := copy (s, 1, j-1);
      delete (s, 1, j);
      er.jxtka := (s = '>');
      for j := length(puhass) downto 1 do
        if puhass[j] in ['''','`'] then delete (puhass, j, 1);
      tderandid.addobject (puhass, er);
    end;
    tderandid.delete (i);
  end;
  tderandid.sort;
  tderandid.sorted := true;
end;

procedure td_exit;
begin
  tderandid.free;
  ExitProc := SaveExit;
end;

begin
  SaveExit := ExitProc;
  ExitProc := @td_exit;
  filemode := $40;
  est_morpho_data := get_morpho_dir;
  loe_tderandid;
end.
