unit demo_unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls;

type
  TFormMain = class(TForm)
    sqna: TEdit;
    RadioGroupApp: TRadioGroup;
    RadioGroupCodeType: TRadioGroup;
    ButtonDoIt: TButton;
    Button1: TButton;
    tulemus: TMemo;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure ButtonDoItClick(Sender: TObject);
    procedure tee_paradigma;
    procedure sqnaKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

type
  SynthForm =
  record
    vorm : array[0..29] of char;
    stemLength : integer;
  end;

  SynthFormSet =
  record
    tyybinumber : integer;
    sqnaliik : array[0..2] of char;
    variandinumber : integer;
    paralleelvorme : integer;
    vormikood : array[0..29] of char;
    vormid : array[0..4] of SynthForm;
  end;


function
  SynthesizeForms(
    lemma : PChar;
    withApp : integer;
    codeType : integer;
    var outBuf : array of SynthFormSet;
    bufLength : integer) : integer;
  stdcall; external 'fmsynth.dll';

implementation

{$R *.DFM}

procedure TFormMain.Button1Click(Sender: TObject);
begin
  FormMain.Close;
end;

procedure TFormMain.ButtonDoItClick(Sender: TObject);
begin
  tee_paradigma;
end;

procedure TFormMain.tee_paradigma;
var
// silma jrgi peaks 300 vormi piisama
  formsBuffer : array[0..299] of SynthFormSet;
  synteesitudvorme, i, j, x_tyybinumber, x_variandinumber : integer;
  lemma : array [0..29] of char;
  itemStr, x_sqnaliik : string;
  valde, valjundkood : integer;
begin
// siin oleks mistlik sodi vlja puhastada.
  if sqna.text = '' then exit;
  tulemus.clear;

  x_tyybinumber := 0;
  x_variandinumber := 0;
  x_sqnaliik := '';

  strlcopy (lemma, pchar(sqna.text), 29);

  valde := radiogroupapp.itemindex;
  valjundkood := radiogroupcodetype.itemindex;
  synteesitudvorme :=
    SynthesizeForms (lemma, valde, valjundkood, formsBuffer, 300);
  if synteesitudvorme > 300 then synteesitudvorme := 300;

  tulemus.lines.beginupdate;
  if synteesitudvorme = 0 then
  begin
    tulemus.lines.add (sqna.text);
    tulemus.lines.add ('Sellist lemmat reeglid ei lubanud!');
  end
  else
  for i := 0 to synteesitudvorme - 1 do
  begin
    if (formsBuffer[i].tyybinumber <> x_tyybinumber) or
       (string (formsBuffer[i].sqnaliik) <> x_sqnaliik) or
       (formsBuffer[i].variandinumber <> x_variandinumber) then
    begin
      if i > 0 then tulemus.lines.add ('');
      tulemus.lines.add ('*** ' + 'muuttp / declination type -- '
        + inttostr (formsBuffer[i].tyybinumber));
      tulemus.lines.add ('*** ' + 'snaliik / part of speech -- '
        + string (formsBuffer[i].sqnaliik));
      tulemus.lines.add ('*** ' + 'variant '
        + inttostr (formsBuffer[i].variandinumber));
      tulemus.lines.add ('');
      x_tyybinumber := formsBuffer[i].tyybinumber;
      x_sqnaliik := formsBuffer[i].sqnaliik;
      x_variandinumber := formsBuffer[i].variandinumber;
    end;

    itemStr := formsBuffer[i].vormikood;
    while length(itemstr) < 12 do itemstr := itemstr + ' ';

    for j := 0 to formsBuffer[i].paralleelvorme - 1 do
    begin
      if j > 0 then itemStr := itemStr + ' ~ ';
      itemStr := itemStr + formsBuffer[i].vormid[j].vorm +
                 ' (' + inttostr (formsBuffer[i].vormid[j].stemLength) + ')';
    end;
    tulemus.lines.add (itemStr);
  end;
  tulemus.lines.endupdate;
  sqna.setfocus;
  sqna.selectall;
end;

procedure TFormMain.sqnaKeyPress(Sender: TObject; var Key: Char);
begin
  if key = chr($0d) then tee_paradigma;
  if key = chr($1b) then formmain.close;
end;

end.
