#include "derivres.hpp"


DerivationResult::DerivationResult(const DerivationResult &other):
fValue(other.fValue), fStemCode(other.fStemCode), fExcCode(other.fExcCode),
fpPrevious(0), fHasDescendants(other.fHasDescendants), fIgnored(other.fIgnored),
fRepeating(other.fRepeating), fHasHistory(other.fHasHistory)
{
   if(fHasHistory && other.fpPrevious)
      fpPrevious=new DerivationResult(*(other.fpPrevious));
}

DerivationResult::~DerivationResult()
{
   if(fHasHistory && fpPrevious){
      delete fpPrevious;
      fpPrevious=0;
   }
}

DerivationResult* DerivationResult::newResult(const std_string &val,
                                              const std_string &sCode,
                                              const std_string &excCode)
{
   DerivationResult *pNew=new DerivationResult(val, sCode, excCode);
   if(fHasHistory)
   {
      pNew->enableHistory();
      if(fHasDescendants)
         pNew->setPrevious(new DerivationResult(*this));
      else
      {
         pNew->setPrevious(this);
         fHasDescendants=1;
      }
   }
   return pNew;
}


