#ifndef DERIVRES_HPP
#define DERIVRES_HPP

#include "strndef.hpp"
#include <deque>

class DerivationResult
{
public:
  DerivationResult() : fValue(""), fStemCode(""), fExcCode(""), fpPrevious(0),
                       fHasDescendants(0), fIgnored(0), fRepeating(0), fHasHistory(0) { }
  DerivationResult(const std_string &val, const std_string &sCode=std_string(""),
                   const std_string &excCode=std_string("")) :
                   fValue(val), fStemCode(sCode), fExcCode(excCode),
                   fpPrevious(0), fHasDescendants(0), fIgnored(0), fRepeating(0), fHasHistory(0) { }
  DerivationResult(const DerivationResult &other);
  ~DerivationResult();
  DerivationResult *newResult(const std_string &val=std_string(),
                              const std_string &sCode=std_string(),
                              const std_string &excCode=std_string());
  std_string value() const { return fValue; }
  void setValue(const std_string &val) { fValue=val; }
  std_string stemCode() const { return fStemCode; }
  void setStemCode(const std_string &sCode) { fStemCode=sCode; }
  std_string exceptionCode() const { return fExcCode; }
  void setExceptionCode(const std_string &excCode) { fExcCode=excCode; }
  DerivationResult* previous() const { return fpPrevious; }
  void setPrevious(DerivationResult *prev) { fpPrevious=prev; }
  int operator==(const DerivationResult &res) { return this==&res; }
  int ignored() { return fIgnored; }
  void setIgnored(int ignored=1) { fIgnored=ignored; }
  int repeating() { return fRepeating; }
  void setRepeating(int repeating=1) { fRepeating=repeating; }
  int isDeadEnd() { return fIgnored || fRepeating; }
  void enableHistory(int enabled=1) { fHasHistory=enabled; }
  int historyEnabled() { return fHasHistory; }
private:
  std_string fValue;
  std_string fStemCode;
  std_string fExcCode;
  DerivationResult *fpPrevious;
  char fHasDescendants:1;
  char fHasHistory:1;
  char fIgnored:1;
  char fRepeating:1;
};

#ifdef __BORLANDC__
typedef std::deque<DerivationResult*> ResultCollection;
typedef std::deque<ResultCollection*> Result2Collection;
#else
typedef deque<DerivationResult*> ResultCollection;
typedef deque<ResultCollection*> Result2Collection;
#endif


inline void FlushCollection(ResultCollection &coll)
{
  ResultCollection::iterator iter;
  for(iter=coll.begin(); iter!=coll.end(); iter++)
    delete *iter;
  coll.erase(coll.begin(), coll.end());
}



#endif /* DERIVRES_HPP */
