#ifndef __FMSYNTH_EXP_HPP__
#define __FMSYNTH_EXP_HPP__

#ifdef LINUX_PORT
#if !defined(_stdcall)
#define _stdcall
#endif
#endif


const int kSynthFormLength = 30;
const int kSynthCodeLength = 30;
const int kSynthKindLength = 3;
const int kMaxParallelForms = 5;

const int kMaxForms = 100;
//const int kNounForms = 30;
//const int kVerbForms = 52;
const int kNumTypes = 41;
const int kNumNounTypes = 27;
const int kMaxCodeStrings = 3;


struct SynthForm
{
  char fForm[kSynthFormLength];
  int fStemLength;
};

struct SynthFormRecord
{
  int fType;
  char fKind[kSynthKindLength];
  int fVariant;
  int fNumForms;
  char fCode[kSynthCodeLength];
  SynthForm fForms[kMaxParallelForms];
};

extern "C" int _stdcall SynthesizeForms(const char *lemma, int withApp, int codeType,
                               SynthFormRecord *pOutBuf, int bufLength);

#endif

