#ifndef __FORMRULE_HPP__
#define __FORMRULE_HPP__

#include <stems_exp.h>
#include "fmsynth_exp.h"
#include "formset.hpp"
#include "synthexc.hpp"
#include <deque>
#include <map>
#include <string>


class FormRule
{
public:
  FormRule(const std_string &bcode, const std_string &end, bool altern) :
    fBaseCode(bcode), fEnd(end), fAltern(altern) {}
  FormRule(const FormRule &rule) :
    fBaseCode(rule.fBaseCode), fEnd(rule.fEnd), fAltern(rule.fAltern) {}
  FormRule() : fBaseCode(), fEnd(), fAltern(false) {}
  FormRule &operator=(const FormRule &rule)
  {
    fBaseCode = rule.fBaseCode; fEnd = rule.fEnd; fAltern = rule.fAltern;
    return *this;
  }

  std_string getBaseCode() const { return fBaseCode; }
  std_string getEnd() const { return fEnd; }
  bool hasAlternative() const { return fAltern; }

  AForm convert(PureFormRecord *pBaseFormArr, int start, int end) const;
private:
  std_string fBaseCode;
  std_string fEnd;
  bool fAltern;
};

#ifdef __BORLANDC__
typedef std::deque<FormRule> RuleCollection;
typedef std::map<std::string, int, std::less<std::string> > CodeToIndex;
#else
typedef deque<FormRule> RuleCollection;
typedef map<string, int, less<string> > CodeToIndex;
#endif

class FormGenerator;

class RuleSet
{
public:
  RuleSet() : fNumForms(0) {}
  void addRule(int code, const FormRule &rule);
  void convert(const FormGenerator &gen,
               const char *lemma, PureFormRecord *pBaseFormArr, int start, int end, int nType,
               const string &kind, int nVariant, int withAppostr, int codeType,
               SynthFormRecord *pOutBuf, int bufLength, int &nForms) const;
  void setExcReg(SynthExceptionRegistry *pReg) { fpExcReg = pReg; }
private:
  RuleCollection fRules[kMaxForms];
  int fNumForms;
  SynthExceptionRegistry *fpExcReg;
};

class FormGenerator
{
public:
  FormGenerator(const char *codeFileName, const char *fileName,
                const char *excFileName);
  ~FormGenerator() {}
  void initialise(const char *fileName);
  int convert(const char *lemma, int withApp, int codeType,
              SynthFormRecord *pOutBuf, int bufLength);

  const char* nounCode(int n, int k) const
  { return fNounCodeStrings[n * kMaxCodeStrings + k]; }

  const char* verbCode(int n, int k) const
  { return fVerbCodeStrings[n * kMaxCodeStrings + k]; }

  int nounForms() const { return fnNounForms; }
  int verbForms() const { return fnVerbForms; }

  const CodeToIndex& codeToIndex() const { return fCodeToIndex; } 

private:
  void getTypes(const char *lemma, int withApp, int *typeNumbers, string *kinds, int &nTypes);
  void loadCodes(const char *fileName);
  void loadCodesFromSection(const char *fileName,
                            const char *section,
                            char codeArray[][kSynthCodeLength],
                            int nBeginning,
                            int &nCodes);
  RuleSet fSets[kNumTypes];
  SynthExceptionRegistry fExcReg;
  char fNounCodeStrings[kMaxForms * kMaxCodeStrings][kSynthCodeLength];
  char fVerbCodeStrings[kMaxForms * kMaxCodeStrings][kSynthCodeLength];
  CodeToIndex fCodeToIndex;
  int fnNounForms;
  int fnVerbForms;
};

#endif
