#include "formset.hpp"

FormSet::FormSet(int t, const std_string &lemma) : fType(t), fLemma(lemma)
{
  fNumForms = t < kNumNounTypes ? kNounForms : kVerbForms;
}

FormSet::~FormSet()
{
}

void FormSet::addForm(int code, const AForm &form)
{
  if(code < kMaxForms)
    fForms[code].push_back(form);
}

const FormCollection& FormSet::getForms(int code) const
{
  if(code < kMaxForms)
    return fForms[code];
  else
    throw "code index out of range";
}
