
#ifdef LINUX_PORT
#define _stdcall
#else
#include <windows.h>
#endif

#ifdef CON_OUTPUT
#include <iostream.h>
#endif
#include <string.h>

#include "patmatch_exp.h"
#include "stems_exp.h"

#if 0
#include "strmaps.hpp"
#endif

#include "grammar.hpp"
#include "stemmgr.hpp"


/*************************************************************************/
RulePrelim Rules_or1[]={
{"C1C1","C1","!WW","li#"},
{"C1C1","C1","'W","li#"},
{"C1C1","C1","!WW","ri#"},
{"C1C1","C1","'W","ri#"},
{"C1C1","C1","!WW","le#"},
{"C1C1","C1","'W","le#"},
{"K1","K1K1","!WW","el#"},
{"K1","K1K1","'W","el#"},
{"K1","K1K1","!WW","er#"},
{"K1","K1K1","'W","er#"}
};

RulePrelim Rules_or2[]={
{"kk","k","'i","#"},
{"k","kk","'i","u#"},
{"kk","k","i","#"},
{"k","kk","i","u#"}
};

RulePrelim Rules_0g[]={
{"g","kk","!WW","W"},
{"b","pp","!WW","W"},
{"d","tt","!WW","W"},
{"H1","H1H1","!WW","W"}
};

RulePrelim Rules_0r[]={
{"i","e","C","#"}
};

RulePrelim Rules_0v[]={
{"i","e","C","#"},
{"u","e","C","#"},
{"e","i","C","#"},
{"a","u","Wi","#"},
{"a","u","YC","#"},
{"a","u","YCC","#"},
{"a","u","YCCC","#"},
{"a","i","C","#"}
};

RulePrelim Rules_ab[]={
{"0","se","Wke","#"},
{"ne","se","0","#"},
{"le","el","C","#"},
{"el","li","WWC","#"},
{"el","li","'WWC","#"},
{"el","li","WCC","#"},
{"el","li","'WCC","#"},
{"el","li","WCCC","#"},
{"el","li","'WCCC","#"},
{"er","ri","WWC","#"},
{"er","ri","'WWC","#"},
{"er","ri","WCC","#"},
{"er","ri","'WCC","#"},
{"er","ri","WCCC","#"},
{"er","ri","'WCCC","#"},
{"e","0","el","#"},
{"0","da","!WWZe","#"},
{"0","a","kond","#"},
{"0","a","k'ond","#"},
{"d","0","nu","#"},
{"d","0","tu","#"},
{"d","0","du","#"},
{"0","u","Ing","#"},
{"0","u","C'ik","#"},
{"0","u","CIk","#"},
{"0","a","CWm","#"},
{"0","a","Zin","#"},
{"0","a","CWv","#"},
{"s","0","Ca","#"},
{"0","e","ius","#"},
{"0","e","CWs","#"},
{"0","i","C","#"}
};

RulePrelim Rules_ba[]={
{"0","s","ja","#"},
{"0","s","Wka","#"},
{"da","0","e","#"},
{"a","0","kond","#"},
{"a","0","k'ond","#"},
{"a","0","CWm","#"},
{"a","0","CWv","#"},
{"a","0","Zin","#"},
{"li","el","!WWK","#"},
{"li","el","'WK","#"},
{"li","el","WWC","#"},
{"li","el","'WWC","#"},
{"li","el","WCC","#"},
{"li","el","'WCC","#"},
{"li","el","WCCC","#"},
{"li","el","'WCCC","#"},
{"ri","er","!WWK","#"},
{"ri","er","'WK","#"},
{"ri","er","WWC","#"},
{"ri","er","'WWC","#"},
{"ri","er","WCC","#"},
{"ri","er","'WCC","#"},
{"ri","er","WCCC","#"},
{"ri","er","'WCCC","#"},
{"i","0","C","#"},
{"se","(ne)","Wke","#"},
{"se","ne","C","#"},
{"se","ne","a","#"},
{"se","ne","e","#"},
{"se","ne","li","#"},
{"se","ne","mi","#"},
{"se","ne","stiku","#"},
{"e","0","ius","#"},
{"e","0","CWs","#"},
{"0","d","stu","#"},
{"0","d","Ntu","#"},
{"0","d","Wtu","#"},
{"0","d","Ndu","#"},
{"0","d","WWdu","#"},
{"0","d","'WWdu","#"},
{"0","d","nu","#"},
{"u","0","Ing","#"},
{"u","0","Cikk","#"},
{"u","0","C'ikk","#"},
{"u","0","CIk","#"},
{"0","e","!WWZel","#"},
{"el","le","!WWK","#"},
{"el","le","'WK","#"},
{"el","le","WWC","#"},
{"el","le","'WWC","#"},
{"el","le","WCC","#"},
{"el","le","'WCC","#"},
{"el","le","WCCC","#"},
{"el","le","'WCCC","#"}
};

RulePrelim Rules_bc[]={
{"e","0","Ws","#"}
};

RulePrelim Rules_cb[]={
{"0","e","Ws","#"}
};

RulePrelim Rules_g0[]={
{"kk","g","W","W"},
{"kk","g","'W","W"},
{"pp","b","W","W"},
{"pp","b","'W","W"},
{"tt","d","W","W"},
{"tt","d","'W","W"},
{"H1H1","H1","W","W"},
{"H1H1","H1","'W","W"}
};

RulePrelim Rules_nt[]={
{"d","d","oi","i"},
{"g","g","oo","i"},
{"g","g","faa","i"},
{"Q1","Q1Q1","!WW","W"},
{"s","ss","!WWL","W"},
{"g","k","WW","W"},
{"g","k","WL","W"},
{"g","k","W","JW"},
{"d","t","WW","W"},
{"d","t","WL","W"},
{"d","t","W","JW"},
{"b","p","WW","W"},
{"b","p","WL","W"},
{"b","p","W","JW"},
{"N1","d","!WWN1","E"},
{"m","b","!WWm","E"},
{"0","t","!WWh","E"},
{"0","k","!WWs","E"}
};

RulePrelim Rules_r0[]={
{"e","e","Cs","#"},
{"e","i","C","#"}
};

RulePrelim Rules_tn[]={
{"Q1Q1","Q1","!WW","W"},
{"ss","s","!WWL","W"},
{"ss","s","WW","W"},
{"p","b","WW","W"},
{"p","b","WL","W"},
{"p","b","W","JW"},
{"k","g","WW","W"},
{"k","g","WL","W"},
{"k","g","W","JW"},
{"t","d","WW","W"},
{"t","d","WL","W"},
{"t","d","W","JW"},
{"b","m","!WWm","E"},
{"d","n","!WWn","E"},
{"d","l","!WWl","E"},
{"d","r","!WWr","E"},
{"t","0","!WWh","W"},
{"k","0","!WWh","W"},
{"k","0","Ws","E"},
{"Q1Q1","Q1","'W","W"},
{"ss","s","'WL","W"},
{"ss","s","'WW","W"},
{"p","b","'WW","W"},
{"p","b","'WL","W"},
{"p","b","'W","JW"},
{"k","g","'WW","W"},
{"k","g","'WL","W"},
{"k","g","'W","JW"},
{"t","d","'WW","W"},
{"t","d","'WL","W"},
{"t","d","'W","JW"},
{"b","m","'Wm","E"},
{"d","n","'Wn","E"},
{"d","l","'Wl","E"},
{"d","r","'Wr","E"},
{"t","0","'Wh","W"},
{"k","0","'Wh","W"},
{"k","0","'Ws","E"}
};

RulePrelim Rules_v0[]={
{"e","u","Cik","#"},
{"e","u","C'ikk","#"},
{"e","i","C","#"},
{"u","a","Wi","#"},
{"u","a","YC","#"},
{"u","a","YCC","#"},
{"u","a","YCCC","#"},
{"i","e","Ws","#"},
{"i","a","XC","#"},
{"i","a","XCC","#"},
{"i","a","XCCC","#"}
};

/*************************************************************************/

StemManager StemManagerObject;
ExceptionRegistry ExcRegistryNT("nt_tn.exc");
ExceptionRegistry ExcRegistry0G("0g_g0.exc");
ExceptionRegistry ExcRegistry0R("0r_r0.exc");
ExceptionRegistry ExcRegistry0V("0v_v0.exc");
ExceptionRegistry ExcRegistryAB("ab_ba.exc");
ExceptionRegistry ExcRegistryBC("bc_cb.exc");
ExceptionRegistry ExcRegistryOrt1("ort1.exc");
ExceptionRegistry ExcRegistryOrt2("ort2.exc");

void loadGrammars();
void convertToStrings(ResultCollection *pResults, std_string &results, std_string &history);

extern "C" char* _stdcall CreateStemVariantByRules(char *grammarName, char *inputString, int withAppostr)
{
   std_string stemVariant;
   Grammar *pGrammar=(Grammar*)StemManagerObject.findGrammar(grammarName);
   if(pGrammar)
   {
      ResultCollection *pResults=new ResultCollection;
      DerivationResult *pInput=new DerivationResult(inputString);
      pGrammar->transform(pResults, pInput, withAppostr, "", 0);
      std_string history;
      convertToStrings(pResults, stemVariant, history);
      FlushCollection(*pResults);
      delete pResults;
   }
   return strdup(stemVariant.c_str());
}

extern "C" int _stdcall FindSignificantPosition(char *inputString)
{
   return significantPosition(std_string(inputString));
}

extern "C" void _stdcall ReloadGrammars()
{
   StemManagerObject.unloadGrammars();
   loadGrammars();
}

extern "C" char* _stdcall FindException(int start, int typeId, char *inputString)
{
   int dummy=0;
   std_string outString="" /* ExcRegistryNT.findExceptions(start, typeId, inputString, 0, &dummy) */;
   return strdup(outString.c_str());
}

extern "C" void _stdcall CreateLemma(char *inputString, int stemNr, char *stemCode,
                                     char *pLemma, int lemmaLength,
                                     char *pHistory, int histLength,
                                     int withAppostr)
{
   ResultCollection *pResults=StemManagerObject.createLemma(inputString, stemNr,
                                                            stemCode, withAppostr);
   std_string results, history;
   convertToStrings(pResults, results, history);
   FlushCollection(*pResults);
   delete pResults;
   strncpy(pHistory, history.c_str(), histLength-1);
   *(pHistory+histLength-1)=0;
   strncpy(pLemma, results.c_str(), lemmaLength-1);
   *(pLemma+lemmaLength-1)=0;
}

extern "C" FormRecord* _stdcall CreateForms(char *inputString, int stemNr,
                                            int withAppostr)
{
   ResultCollection *pResults=StemManagerObject.createForms(inputString, stemNr,
                                                            withAppostr);
   FormRecord *pLastRec=0, *pFirstRec=0;
   ResultCollection::iterator iter;
   for(iter=pResults->begin(); iter!=pResults->end(); iter++)
   {
      DerivationResult *pRes=*iter;
      FormRecord *pRec=new FormRecord;
      strncpy(pRec->form, pRes->value().c_str(), kFormLength-1);
      pRec->form[kFormLength-1]='\0';
      strncpy(pRec->code, pRes->stemCode().c_str(), kCodeLength-1);
      pRec->code[kCodeLength-1]='\0';
      strncpy(pRec->excMarker, pRes->exceptionCode().c_str(), kExcMarkerLength-1);
      pRec->excMarker[kExcMarkerLength-1]='\0';
      pRec->next=0;
      if(!pFirstRec)
         pFirstRec=pRec;
      if(pLastRec)
         pLastRec->next=pRec;
      pLastRec=pRec;
   }
   FlushCollection(*pResults);
   delete pResults;

   return pFirstRec;
};

extern "C" int _stdcall CreateFormsOnArray(char *inputString, int stemNr,
                                           PureFormRecord *pArray, int arraySize,
                                           int withAppostr)

{
  int nForms=0;
  memset(pArray, '\0', arraySize*sizeof(PureFormRecord));

  ResultCollection *pResults=StemManagerObject.createForms(inputString, stemNr,
                                                           withAppostr);
  nForms = pResults->size();

  int nCopied = 0;

  ResultCollection::iterator iter;
  for(iter=pResults->begin(); nCopied<arraySize && iter!=pResults->end(); iter++)
  {
    DerivationResult *pRes=*iter;
    strncpy(pArray[nCopied].form, pRes->value().c_str(), kFormLength-1);
    strncpy(pArray[nCopied].code, pRes->stemCode().c_str(), kCodeLength-1);
    strncpy(pArray[nCopied].excMarker, pRes->exceptionCode().c_str(), kExcMarkerLength-1);
    nCopied++;
  }
  FlushCollection(*pResults);
  delete pResults;

  return nForms;
};


extern "C" void _stdcall FreeForms(FormRecord* pRecord)
{
   FormRecord *pTmp;
   while(pRecord)
   {
      pTmp=pRecord;
      pRecord=pRecord->next;
      delete pTmp;
   }
}

extern "C" void* _stdcall CreateStemMaps(char *inputString,  int stemNr)
{
#if 0
   StringToFormsMapsArray *pMapArray=new StringToFormsMapsArray(4, 0, 4);
   ResultCollection *pResults=StemManagerObject.createForms(inputString, stemNr, 0);
   FormRecord *pLastRec=0, *pFirstRec=0;
   int firstTime=1;
   DerivationResult *pFirstRes=0;
   StringToFormsMap *pMap=0;
   ResultCollectionIterator iter;
   for(iter=pResults->begin(); iter!=pResults->end(); iter++)
   {
      DerivationResult *pRes=*iter;

      if(firstTime){
         pFirstRes=pRes;
         firstTime=0;
      }
      if(pRes->stemCode()==pFirstRes->stemCode()){
         pMap=new StringToFormsMap;
         pMapArray->Add(pMap);
      }

      FormArray *pFormArray=new FormArray(1, 0, 1);
      pFormArray->Add(FormEndPair(pRes->value()));
      StringToFormsAssociation assoc(pRes->stemCode(), pFormArray);
      pMap->Add(assoc);
   }

   pResults->Flush(TShouldDelete::Delete);
   delete pResults;

   return pMapArray;
#else
  return 0;
#endif
};


extern "C" void* _stdcall InitExceptionRegistry(char *fileName, int indexMode)
{
   ExceptionRegistry *pRegistry=new ExceptionRegistry(fileName);
   pRegistry->setIndexMode((ExceptionRegistry::IndexMode)indexMode);
   pRegistry->createIndices();
   return pRegistry;
}

extern "C" int _stdcall SearchExceptionRegistry(void *pRegistry,
                                                  char *pInput, int typeId,
                                                  char *grammarName,
                                                  int fromCol,
                                                  int withAppostr,
                                                  char ***pppOutput,
                                                  int *pOutputLength,
                                                  int *pHasRuleBasedAlso)
{
#if 0
   StringArray *pOutArray=((ExceptionRegistry*)pRegistry)->
        findPdgmExceptions(pInput, fromCol, typeId,
                           grammarName, withAppostr,
                           pHasRuleBasedAlso);
   if(pOutArray && !pOutArray->IsEmpty())
   {
      *pOutputLength=pOutArray->GetItemsInContainer();
      *pppOutput=new char*[*pOutputLength];
      int i=0;
      for(StringArrayIterator iter(*pOutArray); iter && i<*pOutputLength; iter++, i++)
         *(*pppOutput+i)=strdup(iter.Current().c_str());
      delete pOutArray;
      return 1;
   }
   else
#endif
      return 0;
}

extern "C" void _stdcall DestroyExceptionRegistry(void *pRegistry)
{
   if(pRegistry)
      delete (ExceptionRegistry*)pRegistry;
}

extern "C" void _stdcall BeginInitExcRegs()
{
}

extern "C" void _stdcall EndInitExcRegs()
{
}

#ifdef LINUX_PORT
extern "C" void initStemManager()
{
  initPatternMatcher();
  StemManagerObject.loadFromFile("stemguid.txt");
  StemManagerObject.setOrtography(0, "ort1");
  StemManagerObject.setOrtography(1, "ort2");
  loadGrammars();
}
#else

BOOL WINAPI DllEntryPoint(HANDLE hinstDll, DWORD fdwReason, LPVOID lpvReserved)
{
	if(fdwReason==DLL_PROCESS_ATTACH){
   	StemManagerObject.loadFromFile("stemguid.txt");
   	StemManagerObject.setOrtography(0, "ort1");
   	StemManagerObject.setOrtography(1, "ort2");
   	loadGrammars();
   }

   return 1;
}

#endif

void loadGrammars()
{
   ExcRegistryNT.createIndices();
   ExcRegistry0G.createIndices();
   ExcRegistry0R.createIndices();
   ExcRegistry0V.createIndices();
   ExcRegistryAB.createIndices();
   ExcRegistryBC.createIndices();
   ExcRegistryOrt1.createIndices();
   ExcRegistryOrt2.createIndices();

   StemManagerObject.addGrammar("nt", "rules_nt.rul", Rules_nt, sizeof(Rules_nt)/sizeof(RulePrelim), &ExcRegistryNT, 1);
   StemManagerObject.addGrammar("tn", "rules_tn.rul", Rules_tn, sizeof(Rules_tn)/sizeof(RulePrelim), &ExcRegistryNT, 0);
   StemManagerObject.addGrammar("0g", "rules_0g.rul", Rules_0g, sizeof(Rules_0g)/sizeof(RulePrelim), &ExcRegistry0G, 1);
   StemManagerObject.addGrammar("g0", "rules_g0.rul", Rules_g0, sizeof(Rules_g0)/sizeof(RulePrelim), &ExcRegistry0G, 0);
   StemManagerObject.addGrammar("ab", "rules_ab.rul", Rules_ab, sizeof(Rules_ab)/sizeof(RulePrelim), &ExcRegistryAB, 1);
   StemManagerObject.addGrammar("ba", "rules_ba.rul", Rules_ba, sizeof(Rules_ba)/sizeof(RulePrelim), &ExcRegistryAB, 0);
   StemManagerObject.addGrammar("bc", "rules_bc.rul", Rules_bc, sizeof(Rules_bc)/sizeof(RulePrelim), &ExcRegistryBC, 1);
   StemManagerObject.addGrammar("cb", "rules_cb.rul", Rules_cb, sizeof(Rules_cb)/sizeof(RulePrelim), &ExcRegistryBC, 0);
   StemManagerObject.addGrammar("0v", "rules_0v.rul", Rules_0v, sizeof(Rules_0v)/sizeof(RulePrelim), &ExcRegistry0V, 1);
   StemManagerObject.addGrammar("v0", "rules_v0.rul", Rules_v0, sizeof(Rules_v0)/sizeof(RulePrelim), &ExcRegistry0V, 0);
   StemManagerObject.addGrammar("0r", "rules_0r.rul", Rules_0r, sizeof(Rules_0r)/sizeof(RulePrelim), &ExcRegistry0R, 1);
   StemManagerObject.addGrammar("r0", "rules_r0.rul", Rules_r0, sizeof(Rules_r0)/sizeof(RulePrelim), &ExcRegistry0R, 0);

   StemManagerObject.addGrammar("ort1", "rule_or1.rul", Rules_or1, sizeof(Rules_or1)/sizeof(RulePrelim), &ExcRegistryOrt1, 1);
   StemManagerObject.addGrammar("ort2", "rule_or2.rul", Rules_or2, sizeof(Rules_or2)/sizeof(RulePrelim), &ExcRegistryOrt2, 1);
}


void convertToStrings(ResultCollection *pResults, std_string &results, std_string &history)
{
  ResultCollection::iterator iter;
   for(iter=pResults->begin(); iter!=pResults->end(); iter++)
   {
      if(!(*iter)->repeating() && !(*iter)->value().empty())
      {
         if(!results.empty())
            results+="|";
         results+=(*iter)->value();
         std_string exceptionCodes;
         for(DerivationResult *pRes=*iter; pRes; pRes=pRes->previous())
         {
            if(!pRes->exceptionCode().empty())
            {
               if(!exceptionCodes.empty())
                  exceptionCodes=";"+exceptionCodes;
               exceptionCodes=pRes->exceptionCode()+exceptionCodes;
            }
         }
         if(!exceptionCodes.empty())
            results+="("+exceptionCodes+")";
      }
      if(!history.empty())
         history+=" | ";
      std_string historyComp("");
      for(DerivationResult *pRes=*iter; pRes; pRes=pRes->previous())
      {
         historyComp="["+pRes->stemCode()+"]"+historyComp;
         if(!pRes->exceptionCode().empty())
            historyComp="("+pRes->exceptionCode()+")"+historyComp;
         historyComp=pRes->value()+historyComp;
         if(pRes->previous())
            historyComp="->"+historyComp;
      }
      history+=historyComp;
   }
}

