#ifndef __STEMS_EXP_H__
#define __STEMS_EXP_H__

#ifdef LINUX_PORT
#if !defined(_stdcall)
#define _stdcall
#endif
#endif

const int kFormLength=30;
const int kCodeLength=6;
const int kExcMarkerLength=6;

struct FormRecord
{
   char form[kFormLength];
   char code[kCodeLength];
   char excMarker[kExcMarkerLength];
   FormRecord *next;
};

struct PureFormRecord
{
   char form[kFormLength];
   char code[kCodeLength];
   char excMarker[kExcMarkerLength];
};

#ifdef __cplusplus
extern "C" {
#endif

void _stdcall CreateLemma(char *inputString, int stemNr,
                          char *stemCode, char *pLemma,
                          int lemmaLength, char *pHistory,
                          int histLength,
                          int withAppostr);

FormRecord* _stdcall CreateForms(char *inputString, int stemNr,
                                 int withAppostr);

void _stdcall FreeForms(FormRecord* pRecord);

int _stdcall CreateFormsOnArray(char *inputString, int stemNr,
                                PureFormRecord *pArray, int arraySize,
                                int withAppostr);


#ifdef LINUX_PORT
void initStemManager();
#endif


#ifdef __cplusplus
}
#endif

#endif
