#include <strndef.hpp>
#include <stems_exp.h>
#include <fmsynth_exp.h>
#include <string.h>

struct SynthExceptionData
{
  char nr;
  char lemma[kSynthFormLength];
  char form[kSynthFormLength];
  char formCode[9];
  char homoCode[6];
  char homoForm[kSynthFormLength];
  char excType;

  void set(char n, char *l, char *f, char *fcode, char *hc, char *hf, char eType)
  {
    nr=n;
    strncpy(lemma, l, kSynthFormLength - 1);
    lemma[kSynthFormLength - 1] = 0;
    strncpy(form, f, kSynthFormLength - 1);
    form[kSynthFormLength - 1] = 0;
    strcpy(formCode, fcode);
    strcpy(homoCode, hc);
    strncpy(homoForm, hf, kSynthFormLength - 1);
    homoForm[kSynthFormLength - 1] = 0;
    excType = eType;
  }
};


class SynthExceptionRegistry
{
public:
   SynthExceptionRegistry(const char *exceptFileName);
   ~SynthExceptionRegistry();
   SynthExceptionRegistry& createIndex();
   int SynthExceptionRegistry::findExceptionsStart(const char *lemma, int typeId);
   int SynthExceptionRegistry::getException(int typeId, const char *lemma, const char *formCode,
                                         SynthForm *pRecords,
                                         PureFormRecord *pBaseFormArr, int start, int end,
                                         int withAppostr, int mode, int &nParal, int &done);
private:
   int isIndexFileOutOfDate();
   void readIndexFromFile();
   void saveIndexToFile();
   std_string fExceptFileName;
   unsigned short *fpIndex[kNumTypes];
   SynthExceptionData *fpData;
   unsigned short fTypeSizes[kNumTypes];
   unsigned long fNrLines;
   int fCurrent;
};

inline int flip(int x) { return x^1; }
