#include <fmsynth_exp.h>
#include <stdio.h>
#include <string.h>

#include <list>
#include <strndef.hpp>

#ifdef __BORLANDC__
int  parseArgs(int argc, char **argv, int &codeType, bool &allFormsWanted,
	       std::list<std::string> &wantedForms);
#else
int  parseArgs(int argc, char **argv, int &codeType, bool &allFormsWanted,
	       list<string> &wantedForms);
#endif


int main(int argc, char *argv[])
{
  int codeType = 0;           //soovitud vormikoodi kuju
  bool allFormsWanted = true; //tahetakse ko~iki vorme (vaikimisi JAH)
#ifdef __BORLANDC__
  std::list<std::string> wantedForms;   //soovitud vorminimede list
#else
  list<string> wantedForms
#endif

  //parsime argumente ja teeme kindlaks soovitud vormid
  if(!parseArgs(argc, argv, codeType, allFormsWanted, wantedForms)) {
    fprintf(stderr, "Usage: %s [-c codeType] [-f form1[,form2[,...]]]\n",
	    argv[0]);
    return -1;
  }

  //resultaatide massiiv, lubatud kuni 300 vormi resultaadina yhe so~na jaoks
  SynthFormRecord results[300];
  //tekstirea puhver
  char buf[80];
  //kuni on failis ridu
  while(fgets(buf, 80, stdin)) {
    //eemalda whitespace characterid
    char *lemma = strtok(buf, " \t\n");
    //tyhi rida -> vaata ja"rgmist rida
    if(!lemma)
      continue;

    //trykime lemma (so~na tema algvormis) va"ljundisse
    printf("==> %s:\n", lemma);

    //synteesime ko~ik vormid. Teine argument 0: va"ltema"rkidega ei tegele
    int nForms = SynthesizeForms(buf, 0, codeType,
                                 results, 300);
    //    printf("nForms = %d\n", nForms);

    //ei olegi vorme! vaatame ja"rgmist so~na
    if(!nForms)
      continue;

    //Vorme on rohkem kui massiivis kohti. Vaatleme a"ra ko~ik vormid
    //mis parasjagu massiivis - ei loe yle otsa.
    if(nForms > 300)
      nForms = 300;

    //tahetakse ko~iki vorme
    if(allFormsWanted) {
      //itereerime yle resultaatide massiivi ja trykime ko~ik vormid va"lja
      for(int i = 0; i < nForms; i++) {
	printf("%02d %2s %d %s: ", results[i].fType, results[i].fKind,
	       results[i].fVariant, results[i].fCode);
	//yhele vormisymbolile vo~ib vastata mitu paralleelvormi
	//na"itame ko~iki paralleelvorme
	for(int k = 0; k < results[i].fNumForms; k++)
	  printf("%s (%d) ", results[i].fForms[k].fForm,
		 results[i].fForms[k].fStemLength);
	printf("\n");
      }
    }
    else {
      //start - resultaatide massiivi indeks millest alustame itereerimist
      int start = 0;
      //kuni start ei viita massiivi lo~ppu
      while(start < nForms) {
	//peame meeles ka"esoleva tyybi ja variandinumbri
	int curType = results[start].fType;
	int curVar = results[start].fVariant;
	//i on resultaatide massiivi alamiteraator yhe variandi piires
	int i = 0;
	//itereerime yle kysitud vormide

#ifdef __BORLANDC__
	for(std::list<std::string>::iterator it = wantedForms.begin();
	    it != wantedForms.end(); it++)
#else
	for(list<string>::iterator it = wantedForms.begin();
	    it != wantedForms.end(); it++)
#endif
	  //itereerime yle resultaatide massiivi ka"esoleva variandi piires
	  for(i = start;
	      i < nForms && results[i].fVariant == curVar &&
		results[i].fType == curType; i++)
	    if(*it == results[i].fCode) {
	      printf("%02d %2s %d %s: ", results[i].fType, results[i].fKind,
		     results[i].fVariant, results[i].fCode);
	      for(int k = 0; k < results[i].fNumForms; k++)
		printf("%s (%d) ", results[i].fForms[k].fForm,
		       results[i].fForms[k].fStemLength);
	      printf("\n");
	    }
	//lykkame stardi ja"rgmise variandi algusesse (pa"rast for-tsyklit
	//on i sobivasi ja"rgmise variandi resultaatide alguses)
	start = i;
      }
    }
  }
  return 0;
}

#ifdef __BORLANDC__
int  parseArgs(int argc, char **argv, int &codeType, bool &allFormsWanted,
	       std::list<std::string> &wantedForms)
#else
int  parseArgs(int argc, char **argv, int &codeType, bool &allFormsWanted,
	       list<string> &wantedForms)
#endif
{
  codeType = 0;
  allFormsWanted = true;
  int cnt = 1;
  int mode = 0; //kontekst: 0 - ei midagi; 1 - '-c'-argument; 2 - '-f'-argument
  //iteratsioon yle argumentide
  for(cnt = 1; cnt < argc; cnt++) {
    char *pArg = argv[cnt];

    if(*pArg == '-') { //argument algab '-'-ga
      pArg++;
      switch(*pArg) {
      case 'c': //avastasime '-c'
	mode = 1; // '-c'-kontekst
	pArg++; //vaatame edaspidi, mis on '-c' ja"rel
	break;
      case 'f': //avastasime '-f'
	mode = 2; // '-f'-contekst
	pArg++; //vaatame edaspidi, mis on '-f' ja"rel
	break;
      default: //ei kumbagi
	break;
      }
    }

    //olenevalt kontekstist
    switch(mode) {
    case 1: //'-c' kontekst
      {
	//loeme vormikoodi kuju numbri (vastab tulbale fcodes.ini-s)
	if(isdigit(*pArg)) {
	  int codeTypeTmp = atoi(pArg);
	  //lubatud ainult 0...2
	  if(codeTypeTmp > 2) {
	    fprintf(stderr, "ERROR: Invalid code type %d. "
		    "(Should be 0, 1, or 2.)\n", codeTypeTmp);
	    return 0;
	  }
	  else 
	    codeType = codeTypeTmp;
	}
      }
    break;
    case 2: //'-f' kontekst
      {
	//loeme komade ja/vo~i tyhikutega eraldatud vorminimede listi ma"llu
	char *sForm = strtok(pArg, ", ");
	while(sForm) {
	  allFormsWanted = false;
	  wantedForms.push_back(sForm);
	  sForm = strtok(0, ", ");
	}
      }
    break;
    }    
  }

  return 1;
}
